/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import kafka.utils.EmptyTestInfo;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataTopicPartitioner;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerHarness;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.mutable.Buffer;

public class TopicBasedRemoteLogMetadataManagerMultipleSubscriptionsTest {
    private static final Logger log = LoggerFactory.getLogger(TopicBasedRemoteLogMetadataManagerMultipleSubscriptionsTest.class);
    private static final int SEG_SIZE = 0x100000;
    private final Time time = new MockTime(1L);
    private final TopicBasedRemoteLogMetadataManagerHarness remoteLogMetadataManagerHarness = new TopicBasedRemoteLogMetadataManagerHarness();

    private TopicBasedRemoteLogMetadataManager rlmm() {
        return this.remoteLogMetadataManagerHarness.remoteLogMetadataManager();
    }

    @BeforeEach
    public void setup() {
        this.remoteLogMetadataManagerHarness.setUp((TestInfo)new EmptyTestInfo());
    }

    @AfterEach
    public void teardown() throws IOException {
        this.remoteLogMetadataManagerHarness.close();
    }

    @Test
    public void testMultiplePartitionSubscriptions() throws Exception {
        String leaderTopic = "leader";
        HashMap<Integer, Buffer> assignedLeaderTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> leaderTopicReplicas = new ArrayList<Integer>();
        leaderTopicReplicas.add(0);
        leaderTopicReplicas.add(1);
        leaderTopicReplicas.add(2);
        assignedLeaderTopicReplicas.put(0, JavaConverters.asScalaBuffer(leaderTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(leaderTopic, (Map)JavaConverters.mapAsScalaMap(assignedLeaderTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        String followerTopic = "follower";
        HashMap<Integer, Buffer> assignedFollowerTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> followerTopicReplicas = new ArrayList<Integer>();
        followerTopicReplicas.add(1);
        followerTopicReplicas.add(2);
        followerTopicReplicas.add(0);
        assignedFollowerTopicReplicas.put(0, JavaConverters.asScalaBuffer(followerTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(followerTopic, (Map)JavaConverters.mapAsScalaMap(assignedFollowerTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        String topicWithNoMessages = "no-messages-topic";
        HashMap<Integer, Buffer> assignedTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> noMessagesTopicReplicas = new ArrayList<Integer>();
        noMessagesTopicReplicas.add(1);
        noMessagesTopicReplicas.add(2);
        noMessagesTopicReplicas.add(0);
        assignedTopicReplicas.put(0, JavaConverters.asScalaBuffer(noMessagesTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(topicWithNoMessages, (Map)JavaConverters.mapAsScalaMap(assignedTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        TopicIdPartition leaderTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(leaderTopic, 0));
        TopicIdPartition followerTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(followerTopic, 0));
        final TopicIdPartition emptyTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(topicWithNoMessages, 0));
        RemoteLogMetadataTopicPartitioner partitioner = new RemoteLogMetadataTopicPartitioner(10){

            public int metadataPartition(TopicIdPartition topicIdPartition) {
                if (emptyTopicIdPartition.equals((Object)topicIdPartition)) {
                    return 1;
                }
                return 0;
            }
        };
        this.remoteLogMetadataManagerHarness.initializeRemoteLogMetadataManager(Collections.emptySet(), true, partitioner);
        RemoteLogSegmentMetadata leaderSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(leaderTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)this.rlmm().addRemoteLogSegmentMetadata(leaderSegmentMetadata).get();
        });
        Assertions.assertEquals((Object)"org.apache.kafka.common.KafkaException: This consumer is not assigned to the target partition 0. Currently assigned partitions: []", (Object)exception.getMessage());
        RemoteLogSegmentMetadata followerSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(followerTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)this.rlmm().addRemoteLogSegmentMetadata(followerSegmentMetadata).get();
        });
        Assertions.assertEquals((Object)"org.apache.kafka.common.KafkaException: This consumer is not assigned to the target partition 0. Currently assigned partitions: []", (Object)exception.getMessage());
        Assertions.assertThrows(RemoteStorageException.class, () -> this.rlmm().listRemoteLogSegments(leaderTopicIdPartition));
        Assertions.assertThrows(RemoteStorageException.class, () -> this.rlmm().listRemoteLogSegments(followerTopicIdPartition));
        this.rlmm().onPartitionLeadershipChanges(Collections.singleton(leaderTopicIdPartition), Collections.emptySet());
        this.waitUntilConsumerCatchesUp(30000L);
        Assertions.assertTrue((boolean)this.rlmm().listRemoteLogSegments(leaderTopicIdPartition).hasNext());
        Assertions.assertThrows(RemoteStorageException.class, () -> this.rlmm().listRemoteLogSegments(followerTopicIdPartition));
        this.rlmm().onPartitionLeadershipChanges(Collections.singleton(emptyTopicIdPartition), Collections.singleton(followerTopicIdPartition));
        TestUtils.waitForCondition(() -> this.rlmm().listRemoteLogSegments(leaderTopicIdPartition).hasNext(), (String)"No segments found");
        TestUtils.waitForCondition(() -> this.rlmm().listRemoteLogSegments(followerTopicIdPartition).hasNext(), (String)"No segments found");
    }

    private void waitUntilConsumerCatchesUp(long timeoutMs) throws TimeoutException, InterruptedException {
        TestUtils.waitForCondition(() -> this.rlmm().readOffsetForPartition(0).orElse(-1L) >= 1L, (long)timeoutMs, (String)"Consumer did not catch up");
    }
}

