/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.specs;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;

public final class OffloadedSegmentSpec {
    private final int sourceBrokerId;
    private final TopicPartition topicPartition;
    private final int baseOffset;
    private final List<ProducerRecord<String, String>> records;

    public OffloadedSegmentSpec(int sourceBrokerId, TopicPartition topicPartition, int baseOffset, List<ProducerRecord<String, String>> records) {
        this.sourceBrokerId = sourceBrokerId;
        this.topicPartition = topicPartition;
        this.baseOffset = baseOffset;
        this.records = records;
    }

    public int getSourceBrokerId() {
        return this.sourceBrokerId;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public int getBaseOffset() {
        return this.baseOffset;
    }

    public List<ProducerRecord<String, String>> getRecords() {
        return this.records;
    }

    public String toString() {
        return String.format("Segment[partition=%s offloaded-by-broker-id=%d base-offset=%d record-count=%d]", this.topicPartition, this.sourceBrokerId, this.baseOffset, this.records.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffloadedSegmentSpec that = (OffloadedSegmentSpec)o;
        return this.sourceBrokerId == that.sourceBrokerId && this.baseOffset == that.baseOffset && Objects.equals(this.topicPartition, that.topicPartition) && Objects.equals(this.records, that.records);
    }

    public int hashCode() {
        return Objects.hash(this.sourceBrokerId, this.topicPartition, this.baseOffset, this.records);
    }
}

