/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage.actions;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;

public final class ExpectLeaderAction
implements TieredStorageTestAction {
    private final TopicPartition topicPartition;
    private final int replicaId;
    private final Boolean electLeader;

    public ExpectLeaderAction(TopicPartition topicPartition, int replicaId, Boolean electLeader) {
        this.topicPartition = topicPartition;
        this.replicaId = replicaId;
        this.electLeader = electLeader;
    }

    @Override
    public void doExecute(TieredStorageTestContext context) throws InterruptedException, ExecutionException {
        String topic = this.topicPartition.topic();
        int partition = this.topicPartition.partition();
        TestUtils.waitForCondition(() -> {
            TopicDescription description = TieredStorageTestUtils.describeTopic(context, topic);
            List isr = ((TopicPartitionInfo)description.partitions().get(partition)).isr();
            return isr != null && isr.stream().anyMatch(node -> node.id() == this.replicaId);
        }, (String)("Broker " + this.replicaId + " is out of sync for " + partition + ". Cannot be elected as leader."));
        this.reassignPartition(context);
        if (this.electLeader.booleanValue()) {
            context.admin().electLeaders(ElectionType.PREFERRED, Collections.singleton(this.topicPartition));
        }
        AtomicInteger actualLeader = new AtomicInteger(-1);
        TestUtils.waitForCondition(() -> {
            try {
                TopicDescription description = TieredStorageTestUtils.describeTopic(context, topic);
                actualLeader.set(Optional.of(((TopicPartitionInfo)description.partitions().get(partition)).leader()).map(Node::id).orElse(-1));
                return this.replicaId == actualLeader.get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof UnknownTopicOrPartitionException) {
                    return false;
                }
                throw new RuntimeException(ex);
            }
        }, (String)("Leader of " + this.topicPartition + " was not " + this.replicaId + ". Actual leader: " + actualLeader));
    }

    @Override
    public void describe(PrintStream output) {
        output.printf("expect-leader: topic-partition: %s, replicaId: %d, electLeader: %s%n", this.topicPartition, this.replicaId, this.electLeader);
    }

    private void reassignPartition(TieredStorageTestContext context) throws ExecutionException, InterruptedException {
        String topic = this.topicPartition.topic();
        TopicPartitionInfo partitionInfo = (TopicPartitionInfo)TieredStorageTestUtils.describeTopic(context, topic).partitions().get(this.topicPartition.partition());
        ArrayList<Integer> targetReplicas = new ArrayList<Integer>();
        targetReplicas.add(this.replicaId);
        partitionInfo.replicas().forEach(replica -> {
            if (replica.id() != this.replicaId) {
                targetReplicas.add(replica.id());
            }
        });
        Map<TopicPartition, Optional<NewPartitionReassignment>> proposed = Collections.singletonMap(this.topicPartition, Optional.of(new NewPartitionReassignment(targetReplicas)));
        context.admin().alterPartitionReassignments(proposed);
    }
}

