/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tiered.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.api.IntegrationTestHarness;
import kafka.log.remote.RemoteLogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.replica.ReplicaSelector;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.storage.ClassLoaderAwareRemoteStorageManager;
import org.apache.kafka.server.log.remote.storage.LocalTieredStorage;
import org.apache.kafka.server.log.remote.storage.RemoteStorageManager;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tiered.storage.TieredStorageTestAction;
import org.apache.kafka.tiered.storage.TieredStorageTestBuilder;
import org.apache.kafka.tiered.storage.TieredStorageTestContext;
import org.apache.kafka.tiered.storage.utils.BrokerLocalStorage;
import org.apache.kafka.tiered.storage.utils.TieredStorageTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Tag(value="integration")
public abstract class TieredStorageTestHarness
extends IntegrationTestHarness {
    private TieredStorageTestContext context;
    private String testClassName = "";
    private String storageDirPath = "";

    public void modifyConfigs(Seq<Properties> props) {
        for (Properties p : JavaConverters.seqAsJavaList(props)) {
            p.putAll((Map<?, ?>)this.overridingProps());
        }
    }

    public Seq<Properties> kraftControllerConfigs() {
        return JavaConverters.asScalaBuffer(Collections.singletonList(this.overridingProps())).toSeq();
    }

    protected int numRemoteLogMetadataPartitions() {
        return 5;
    }

    public Properties overridingProps() {
        Properties overridingProps = TieredStorageTestUtils.createPropsForRemoteStorage(this.testClassName, this.storageDirPath, this.brokerCount(), this.numRemoteLogMetadataPartitions(), new Properties());
        this.readReplicaSelectorClass().ifPresent(c -> overridingProps.put(KafkaConfig.ReplicaSelectorClassProp(), c.getName()));
        return overridingProps;
    }

    protected Optional<Class<ReplicaSelector>> readReplicaSelectorClass() {
        return Optional.empty();
    }

    protected abstract void writeTestSpecifications(TieredStorageTestBuilder var1);

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testClassName = ((Class)testInfo.getTestClass().get()).getSimpleName().toLowerCase(Locale.getDefault());
        this.storageDirPath = TestUtils.tempDirectory((String)("kafka-remote-tier-" + this.testClassName)).getAbsolutePath();
        super.setUp(testInfo);
        this.context = new TieredStorageTestContext(this);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void executeTieredStorageTest(String quorum) {
        TieredStorageTestBuilder builder = new TieredStorageTestBuilder();
        this.writeTestSpecifications(builder);
        try {
            for (TieredStorageTestAction action : builder.complete()) {
                action.execute(this.context);
            }
        }
        catch (Exception ex) {
            throw new AssertionError("Could not build test specifications. No test was executed.", ex);
        }
    }

    @AfterEach
    public void tearDown() {
        try {
            Utils.closeQuietly((AutoCloseable)this.context, (String)"TieredStorageTestContext");
            super.tearDown();
            this.context.printReport(System.out);
        }
        catch (Exception ex) {
            throw new AssertionError("Failed to close the tear down the test harness.", ex);
        }
    }

    public static List<LocalTieredStorage> remoteStorageManagers(Seq<KafkaBroker> brokers) {
        ArrayList<LocalTieredStorage> storages = new ArrayList<LocalTieredStorage>();
        JavaConverters.seqAsJavaList(brokers).forEach(broker -> {
            if (broker.remoteLogManagerOpt().isDefined()) {
                RemoteLogManager remoteLogManager = (RemoteLogManager)broker.remoteLogManagerOpt().get();
                RemoteStorageManager storageManager = remoteLogManager.storageManager();
                if (storageManager instanceof ClassLoaderAwareRemoteStorageManager) {
                    ClassLoaderAwareRemoteStorageManager loaderAwareRSM = (ClassLoaderAwareRemoteStorageManager)storageManager;
                    if (loaderAwareRSM.delegate() instanceof LocalTieredStorage) {
                        storages.add((LocalTieredStorage)loaderAwareRSM.delegate());
                    }
                } else if (storageManager instanceof LocalTieredStorage) {
                    storages.add((LocalTieredStorage)storageManager);
                }
            } else {
                throw new AssertionError((Object)("Broker " + broker.config().brokerId() + " does not have a remote log manager."));
            }
        });
        return storages;
    }

    public static List<BrokerLocalStorage> localStorages(Seq<KafkaBroker> brokers) {
        return JavaConverters.seqAsJavaList(brokers).stream().map(b -> new BrokerLocalStorage(b.config().brokerId(), (String)b.config().logDirs().head(), TieredStorageTestUtils.STORAGE_WAIT_TIMEOUT_SEC)).collect(Collectors.toList());
    }
}

