/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RemoteLogManagerConfigTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidConfigs(boolean useDefaultRemoteLogMetadataManagerClass) {
        String rsmPrefix = "__custom.rsm.";
        String rlmmPrefix = "__custom.rlmm.";
        Map<String, String> rsmProps = Collections.singletonMap("rsm.prop", "val");
        Map<String, String> rlmmProps = Collections.singletonMap("rlmm.prop", "val");
        String remoteLogMetadataManagerClass = useDefaultRemoteLogMetadataManagerClass ? "org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager" : "dummy.remote.log.metadata.class";
        RemoteLogManagerConfig expectedRemoteLogManagerConfig = new RemoteLogManagerConfig(true, "dummy.remote.storage.class", "dummy.remote.storage.class.path", remoteLogMetadataManagerClass, "dummy.remote.log.metadata.class.path", "listener.name", 0x100000L, 1, 60000L, 100L, 60000L, 0.3, 10, 100, 100, rsmPrefix, rsmProps, rlmmPrefix, rlmmProps);
        Map<String, Object> props = this.extractProps(expectedRemoteLogManagerConfig);
        rsmProps.forEach((k, v) -> props.put(rsmPrefix + k, v));
        rlmmProps.forEach((k, v) -> props.put(rlmmPrefix + k, v));
        if (useDefaultRemoteLogMetadataManagerClass) {
            props.remove("remote.log.metadata.manager.class.name");
        }
        TestConfig config = new TestConfig(props);
        RemoteLogManagerConfig remoteLogManagerConfig = new RemoteLogManagerConfig((AbstractConfig)config);
        Assertions.assertEquals((Object)expectedRemoteLogManagerConfig, (Object)remoteLogManagerConfig);
    }

    private Map<String, Object> extractProps(RemoteLogManagerConfig remoteLogManagerConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("remote.log.storage.system.enable", remoteLogManagerConfig.enableRemoteStorageSystem());
        props.put("remote.log.storage.manager.class.name", remoteLogManagerConfig.remoteStorageManagerClassName());
        props.put("remote.log.storage.manager.class.path", remoteLogManagerConfig.remoteStorageManagerClassPath());
        props.put("remote.log.metadata.manager.class.name", remoteLogManagerConfig.remoteLogMetadataManagerClassName());
        props.put("remote.log.metadata.manager.class.path", remoteLogManagerConfig.remoteLogMetadataManagerClassPath());
        props.put("remote.log.metadata.manager.listener.name", remoteLogManagerConfig.remoteLogMetadataManagerListenerName());
        props.put("remote.log.index.file.cache.total.size.bytes", remoteLogManagerConfig.remoteLogIndexFileCacheTotalSizeBytes());
        props.put("remote.log.manager.thread.pool.size", remoteLogManagerConfig.remoteLogManagerThreadPoolSize());
        props.put("remote.log.manager.task.interval.ms", remoteLogManagerConfig.remoteLogManagerTaskIntervalMs());
        props.put("remote.log.manager.task.retry.backoff.ms", remoteLogManagerConfig.remoteLogManagerTaskRetryBackoffMs());
        props.put("remote.log.manager.task.retry.backoff.max.ms", remoteLogManagerConfig.remoteLogManagerTaskRetryBackoffMaxMs());
        props.put("remote.log.manager.task.retry.jitter", remoteLogManagerConfig.remoteLogManagerTaskRetryJitter());
        props.put("remote.log.reader.threads", remoteLogManagerConfig.remoteLogReaderThreads());
        props.put("remote.log.reader.max.pending.tasks", remoteLogManagerConfig.remoteLogReaderMaxPendingTasks());
        props.put("remote.log.metadata.custom.metadata.max.bytes", remoteLogManagerConfig.remoteLogMetadataCustomMetadataMaxBytes());
        props.put("remote.log.storage.manager.impl.prefix", remoteLogManagerConfig.remoteStorageManagerPrefix());
        props.put("remote.log.metadata.manager.impl.prefix", remoteLogManagerConfig.remoteLogMetadataManagerPrefix());
        return props;
    }

    private static class TestConfig
    extends AbstractConfig {
        public TestConfig(Map<?, ?> originals) {
            super(RemoteLogManagerConfig.CONFIG_DEF, originals, true);
        }
    }
}

