/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogSegmentMetadataSnapshotTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class RemoteLogSegmentMetadataSnapshotTransformTest {
    RemoteLogSegmentMetadataSnapshotTransformTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testToAndFromMessage(Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata) {
        HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
        segmentLeaderEpochs.put(0, 0L);
        RemoteLogSegmentMetadataSnapshot snapshot = new RemoteLogSegmentMetadataSnapshot(Uuid.randomUuid(), 0L, 100L, -1L, 0, 0L, 1234, customMetadata, RemoteLogSegmentState.COPY_SEGMENT_FINISHED, segmentLeaderEpochs);
        RemoteLogSegmentMetadataSnapshotTransform transform = new RemoteLogSegmentMetadataSnapshotTransform();
        ApiMessageAndVersion message = transform.toApiMessageAndVersion(snapshot);
        Assertions.assertEquals((Object)snapshot, (Object)transform.fromApiMessageAndVersion(message));
    }

    private static Stream<Object> parameters() {
        return Stream.of(Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3})), Optional.of(new RemoteLogSegmentMetadata.CustomMetadata(new byte[0])), Optional.empty());
    }
}

