/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicBasedRemoteLogMetadataManagerConfigTest {
    private static final Logger log = LoggerFactory.getLogger(TopicBasedRemoteLogMetadataManagerConfigTest.class);
    private static final String BOOTSTRAP_SERVERS = "localhost:9091";

    @Test
    public void testValidConfig() {
        HashMap<String, Object> commonClientConfig = new HashMap<String, Object>();
        commonClientConfig.put("retries", 10);
        commonClientConfig.put("retry.backoff.ms", 1000L);
        commonClientConfig.put("metadata.max.age.ms", 60000L);
        HashMap<String, Object> producerConfig = new HashMap<String, Object>();
        producerConfig.put("acks", "all");
        HashMap<String, Object> consumerConfig = new HashMap<String, Object>();
        consumerConfig.put("enable.auto.commit", false);
        Map<String, Object> props = this.createValidConfigProps(commonClientConfig, producerConfig, consumerConfig);
        TopicBasedRemoteLogMetadataManagerConfig rlmmConfig = new TopicBasedRemoteLogMetadataManagerConfig(props);
        Assertions.assertEquals((Object)props.get("remote.log.metadata.topic.num.partitions"), (Object)rlmmConfig.metadataTopicPartitionsCount());
        Assertions.assertEquals((Object)BOOTSTRAP_SERVERS, rlmmConfig.commonProperties().get("bootstrap.servers"));
        Assertions.assertEquals((Object)BOOTSTRAP_SERVERS, rlmmConfig.producerProperties().get("bootstrap.servers"));
        Assertions.assertEquals((Object)BOOTSTRAP_SERVERS, rlmmConfig.consumerProperties().get("bootstrap.servers"));
        for (Map.Entry entry : commonClientConfig.entrySet()) {
            log.info("Checking config: " + (String)entry.getKey());
            Assertions.assertEquals(entry.getValue(), rlmmConfig.commonProperties().get(entry.getKey()));
            Assertions.assertEquals(entry.getValue(), rlmmConfig.producerProperties().get(entry.getKey()));
            Assertions.assertEquals(entry.getValue(), rlmmConfig.consumerProperties().get(entry.getKey()));
        }
        for (Map.Entry entry : producerConfig.entrySet()) {
            log.info("Checking config: " + (String)entry.getKey());
            Assertions.assertEquals(entry.getValue(), rlmmConfig.producerProperties().get(entry.getKey()));
        }
        for (Map.Entry entry : consumerConfig.entrySet()) {
            log.info("Checking config: " + (String)entry.getKey());
            Assertions.assertEquals(entry.getValue(), rlmmConfig.consumerProperties().get(entry.getKey()));
        }
    }

    @Test
    public void testCommonProducerConsumerOverridesConfig() {
        AbstractMap.SimpleImmutableEntry<String, Long> overrideEntry = new AbstractMap.SimpleImmutableEntry<String, Long>("metadata.max.age.ms", 60000L);
        HashMap<String, Object> commonClientConfig = new HashMap<String, Object>();
        commonClientConfig.put("retries", 10);
        commonClientConfig.put("retry.backoff.ms", 1000L);
        Long overrideCommonPropValue = (Long)overrideEntry.getValue();
        commonClientConfig.put((String)overrideEntry.getKey(), overrideCommonPropValue);
        HashMap<String, Object> producerConfig = new HashMap<String, Object>();
        producerConfig.put("acks", -1);
        Long overriddenProducerPropValue = (Long)overrideEntry.getValue() * 2L;
        producerConfig.put((String)overrideEntry.getKey(), overriddenProducerPropValue);
        HashMap<String, Object> consumerConfig = new HashMap<String, Object>();
        consumerConfig.put("enable.auto.commit", false);
        Long overriddenConsumerPropValue = (Long)overrideEntry.getValue() * 3L;
        consumerConfig.put((String)overrideEntry.getKey(), overriddenConsumerPropValue);
        Map<String, Object> props = this.createValidConfigProps(commonClientConfig, producerConfig, consumerConfig);
        TopicBasedRemoteLogMetadataManagerConfig rlmmConfig = new TopicBasedRemoteLogMetadataManagerConfig(props);
        Assertions.assertEquals((Object)overrideCommonPropValue, rlmmConfig.commonProperties().get(overrideEntry.getKey()));
        Assertions.assertEquals((Object)overriddenProducerPropValue, rlmmConfig.producerProperties().get(overrideEntry.getKey()));
        Assertions.assertEquals((Object)overriddenConsumerPropValue, rlmmConfig.consumerProperties().get(overrideEntry.getKey()));
    }

    private Map<String, Object> createValidConfigProps(Map<String, Object> commonClientConfig, Map<String, Object> producerConfig, Map<String, Object> consumerConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("remote.log.metadata.common.client.bootstrap.servers", BOOTSTRAP_SERVERS);
        props.put("broker.id", 1);
        props.put("log.dir", TestUtils.tempDirectory().getAbsolutePath());
        props.put("remote.log.metadata.topic.replication.factor", (short)3);
        props.put("remote.log.metadata.topic.num.partitions", 10);
        props.put("remote.log.metadata.topic.retention.ms", 3600000L);
        for (Map.Entry<String, Object> entry : commonClientConfig.entrySet()) {
            props.put("remote.log.metadata.common.client." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : producerConfig.entrySet()) {
            props.put("remote.log.metadata.producer." + entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : consumerConfig.entrySet()) {
            props.put("remote.log.metadata.consumer." + entry.getKey(), entry.getValue());
        }
        return props;
    }
}

