/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InmemoryRemoteLogMetadataManager
implements RemoteLogMetadataManager {
    private static final Logger log = LoggerFactory.getLogger(InmemoryRemoteLogMetadataManager.class);
    private Map<TopicIdPartition, RemotePartitionDeleteMetadata> idToPartitionDeleteMetadata = new ConcurrentHashMap<TopicIdPartition, RemotePartitionDeleteMetadata>();
    private Map<TopicIdPartition, RemoteLogMetadataCache> idToRemoteLogMetadataCache = new ConcurrentHashMap<TopicIdPartition, RemoteLogMetadataCache>();
    private static final CompletableFuture<Void> COMPLETED_FUTURE = new CompletableFuture();

    public CompletableFuture<Void> addRemoteLogSegmentMetadata(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Adding remote log segment : [{}]", (Object)remoteLogSegmentMetadata);
        Objects.requireNonNull(remoteLogSegmentMetadata, "remoteLogSegmentMetadata can not be null");
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        this.idToRemoteLogMetadataCache.computeIfAbsent(remoteLogSegmentId.topicIdPartition(), id -> new RemoteLogMetadataCache()).addCopyInProgressSegment(remoteLogSegmentMetadata);
        return COMPLETED_FUTURE;
    }

    public CompletableFuture<Void> updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate metadataUpdate) throws RemoteStorageException {
        log.debug("Updating remote log segment: [{}]", (Object)metadataUpdate);
        Objects.requireNonNull(metadataUpdate, "metadataUpdate can not be null");
        this.getRemoteLogMetadataCache(metadataUpdate.remoteLogSegmentId().topicIdPartition()).updateRemoteLogSegmentMetadata(metadataUpdate);
        return COMPLETED_FUTURE;
    }

    private RemoteLogMetadataCache getRemoteLogMetadataCache(TopicIdPartition topicIdPartition) throws RemoteResourceNotFoundException {
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache == null) {
            throw new RemoteResourceNotFoundException("No existing metadata found for partition: " + topicIdPartition);
        }
        return remoteLogMetadataCache;
    }

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(TopicIdPartition topicIdPartition, int epochForOffset, long offset) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).remoteLogSegmentMetadata(epochForOffset, offset);
    }

    public Optional<Long> highestOffsetForEpoch(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).highestOffsetForEpoch(leaderEpoch);
    }

    public CompletableFuture<Void> putRemotePartitionDeleteMetadata(RemotePartitionDeleteMetadata remotePartitionDeleteMetadata) {
        RemotePartitionDeleteState existingState;
        log.debug("Adding delete state with: [{}]", (Object)remotePartitionDeleteMetadata);
        Objects.requireNonNull(remotePartitionDeleteMetadata, "remotePartitionDeleteMetadata can not be null");
        TopicIdPartition topicIdPartition = remotePartitionDeleteMetadata.topicIdPartition();
        RemotePartitionDeleteState targetState = remotePartitionDeleteMetadata.state();
        RemotePartitionDeleteMetadata existingMetadata = this.idToPartitionDeleteMetadata.get(topicIdPartition);
        RemotePartitionDeleteState remotePartitionDeleteState = existingState = existingMetadata != null ? existingMetadata.state() : null;
        if (!RemotePartitionDeleteState.isValidTransition((RemotePartitionDeleteState)existingState, (RemotePartitionDeleteState)targetState)) {
            throw new IllegalStateException("Current state: " + existingState + ", target state: " + targetState);
        }
        this.idToPartitionDeleteMetadata.put(topicIdPartition, remotePartitionDeleteMetadata);
        if (targetState == RemotePartitionDeleteState.DELETE_PARTITION_FINISHED) {
            this.idToRemoteLogMetadataCache.remove(topicIdPartition);
            this.idToPartitionDeleteMetadata.remove(topicIdPartition);
        }
        return COMPLETED_FUTURE;
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).listAllRemoteLogSegments();
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).listRemoteLogSegments(leaderEpoch);
    }

    public void onPartitionLeadershipChanges(Set<TopicIdPartition> leaderPartitions, Set<TopicIdPartition> followerPartitions) {
    }

    public void onStopPartitions(Set<TopicIdPartition> partitions) {
    }

    public void close() throws IOException {
        this.idToPartitionDeleteMetadata = Collections.emptyMap();
        this.idToRemoteLogMetadataCache = Collections.emptyMap();
    }

    public void configure(Map<String, ?> configs) {
    }

    static {
        COMPLETED_FUTURE.complete(null);
    }
}

