/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManager;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerHarness;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.mutable.Buffer;

public class TopicBasedRemoteLogMetadataManagerTest {
    private static final Logger log = LoggerFactory.getLogger(TopicBasedRemoteLogMetadataManagerTest.class);
    private static final int SEG_SIZE = 0x100000;
    private final Time time = new MockTime(1L);
    private final TopicBasedRemoteLogMetadataManagerHarness remoteLogMetadataManagerHarness = new TopicBasedRemoteLogMetadataManagerHarness();

    @BeforeEach
    public void setup() {
        this.remoteLogMetadataManagerHarness.initialize(Collections.emptySet(), true);
    }

    @AfterEach
    public void teardown() throws IOException {
        this.remoteLogMetadataManagerHarness.close();
    }

    public TopicBasedRemoteLogMetadataManager topicBasedRlmm() {
        return this.remoteLogMetadataManagerHarness.remoteLogMetadataManager();
    }

    @Test
    public void testWithNoAssignedPartitions() throws Exception {
        log.info("Not assigning any partitions on TopicBasedRemoteLogMetadataManager");
    }

    @Test
    public void testNewPartitionUpdates() throws Exception {
        String leaderTopic = "new-leader";
        HashMap<Integer, Buffer> assignedLeaderTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> leaderTopicReplicas = new ArrayList<Integer>();
        leaderTopicReplicas.add(0);
        leaderTopicReplicas.add(1);
        leaderTopicReplicas.add(2);
        assignedLeaderTopicReplicas.put(0, JavaConverters.asScalaBuffer(leaderTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(leaderTopic, (Map)JavaConverters.mapAsScalaMap(assignedLeaderTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        String followerTopic = "new-follower";
        HashMap<Integer, Buffer> assignedFollowerTopicReplicas = new HashMap<Integer, Buffer>();
        ArrayList<Integer> followerTopicReplicas = new ArrayList<Integer>();
        followerTopicReplicas.add(1);
        followerTopicReplicas.add(2);
        followerTopicReplicas.add(0);
        assignedFollowerTopicReplicas.put(0, JavaConverters.asScalaBuffer(followerTopicReplicas));
        this.remoteLogMetadataManagerHarness.createTopicWithAssignment(followerTopic, (Map)JavaConverters.mapAsScalaMap(assignedFollowerTopicReplicas), this.remoteLogMetadataManagerHarness.listenerName());
        TopicIdPartition newLeaderTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(leaderTopic, 0));
        TopicIdPartition newFollowerTopicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition(followerTopic, 0));
        RemoteLogSegmentMetadata leaderSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(newLeaderTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)this.topicBasedRlmm().addRemoteLogSegmentMetadata(leaderSegmentMetadata).get();
        });
        RemoteLogSegmentMetadata followerSegmentMetadata = new RemoteLogSegmentMetadata(new RemoteLogSegmentId(newFollowerTopicIdPartition, Uuid.randomUuid()), 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
        Assertions.assertThrows(Exception.class, () -> {
            Void cfr_ignored_0 = (Void)this.topicBasedRlmm().addRemoteLogSegmentMetadata(followerSegmentMetadata).get();
        });
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.topicBasedRlmm().listRemoteLogSegments(newLeaderTopicIdPartition));
        Assertions.assertThrows(RemoteResourceNotFoundException.class, () -> this.topicBasedRlmm().listRemoteLogSegments(newFollowerTopicIdPartition));
        this.topicBasedRlmm().onPartitionLeadershipChanges(Collections.singleton(newLeaderTopicIdPartition), Collections.singleton(newFollowerTopicIdPartition));
        this.waitUntilConsumerCatchesup(newLeaderTopicIdPartition, newFollowerTopicIdPartition, 30000L);
        Assertions.assertTrue((boolean)this.topicBasedRlmm().listRemoteLogSegments(newLeaderTopicIdPartition).hasNext());
        Assertions.assertTrue((boolean)this.topicBasedRlmm().listRemoteLogSegments(newFollowerTopicIdPartition).hasNext());
    }

    private void waitUntilConsumerCatchesup(TopicIdPartition newLeaderTopicIdPartition, TopicIdPartition newFollowerTopicIdPartition, long timeoutMs) throws TimeoutException {
        int leaderMetadataPartition = this.topicBasedRlmm().metadataPartition(newLeaderTopicIdPartition);
        int followerMetadataPartition = this.topicBasedRlmm().metadataPartition(newFollowerTopicIdPartition);
        log.debug("Metadata partition for newLeaderTopicIdPartition: [{}], is: [{}]", (Object)newLeaderTopicIdPartition, (Object)leaderMetadataPartition);
        log.debug("Metadata partition for newFollowerTopicIdPartition: [{}], is: [{}]", (Object)newFollowerTopicIdPartition, (Object)followerMetadataPartition);
        long sleepMs = 100L;
        long time = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - time > timeoutMs) {
                throw new TimeoutException("Timed out after " + timeoutMs + "ms ");
            }
            if (leaderMetadataPartition == followerMetadataPartition ? this.topicBasedRlmm().receivedOffsetForPartition(leaderMetadataPartition).orElse(-1L) >= 1L : this.topicBasedRlmm().receivedOffsetForPartition(leaderMetadataPartition).orElse(-1L) >= 0L || this.topicBasedRlmm().receivedOffsetForPartition(followerMetadataPartition).orElse(-1L) >= 0L) break;
            log.debug("Sleeping for: " + sleepMs);
            Utils.sleep((long)sleepMs);
        }
    }
}

