/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentLifecycleManager;
import org.apache.kafka.server.log.remote.metadata.storage.TopicBasedRemoteLogMetadataManagerHarness;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogSegmentLifecycleTest {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogSegmentLifecycleTest.class);
    private static final int SEG_SIZE = 0x100000;
    private static final int BROKER_ID_0 = 0;
    private static final int BROKER_ID_1 = 1;
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
    private final Time time = new MockTime(1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testRemoteLogSegmentLifeCycle(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            HashMap<Integer, Long> segment0LeaderEpochs = new HashMap<Integer, Long>();
            segment0LeaderEpochs.put(0, 0L);
            segment0LeaderEpochs.put(1, 20L);
            segment0LeaderEpochs.put(2, 80L);
            RemoteLogSegmentId segment0Id = new RemoteLogSegmentId(this.topicIdPartition, Uuid.randomUuid());
            RemoteLogSegmentMetadata segment0Metadata = new RemoteLogSegmentMetadata(segment0Id, 0L, 100L, -1L, 0, this.time.milliseconds(), 0x100000, segment0LeaderEpochs);
            remoteLogSegmentLifecycleManager.addRemoteLogSegmentMetadata(segment0Metadata);
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(40, 1L).isPresent());
            Stream.of(0, 1, 2).forEach(epoch -> {
                try {
                    Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.highestOffsetForEpoch((int)epoch).isPresent());
                }
                catch (RemoteStorageException e) {
                    Assertions.fail((Throwable)e);
                }
            });
            RemoteLogSegmentMetadataUpdate segment0Update = new RemoteLogSegmentMetadataUpdate(segment0Id, this.time.milliseconds(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, 1);
            remoteLogSegmentLifecycleManager.updateRemoteLogSegmentMetadata(segment0Update);
            RemoteLogSegmentMetadata expectedSegment0Metadata = segment0Metadata.createWithUpdates(segment0Update);
            Map<Integer, Long> segment1LeaderEpochs = Collections.singletonMap(2, 101L);
            RemoteLogSegmentMetadata segment1Metadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, segment1LeaderEpochs, 101L, 200L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            HashMap<Integer, Long> segment2LeaderEpochs = new HashMap<Integer, Long>();
            segment2LeaderEpochs.put(2, 201L);
            segment2LeaderEpochs.put(3, 240L);
            RemoteLogSegmentMetadata segment2Metadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, segment2LeaderEpochs, 201L, 300L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            HashMap<Integer, Long> segment3LeaderEpochs = new HashMap<Integer, Long>();
            segment3LeaderEpochs.put(3, 250L);
            segment3LeaderEpochs.put(4, 370L);
            RemoteLogSegmentMetadata segment3Metadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, segment3LeaderEpochs, 250L, 400L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            HashMap<EpochOffset, RemoteLogSegmentMetadata> expectedEpochOffsetToSegmentMetadata = new HashMap<EpochOffset, RemoteLogSegmentMetadata>();
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(1, 40L), expectedSegment0Metadata);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(2, 110L), segment1Metadata);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(3, 240L), segment2Metadata);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(3, 250L), segment3Metadata);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(4, 375L), segment3Metadata);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(1, 110L), null);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(4, 401L), null);
            expectedEpochOffsetToSegmentMetadata.put(new EpochOffset(5, 301L), null);
            for (Map.Entry entry : expectedEpochOffsetToSegmentMetadata.entrySet()) {
                EpochOffset epochOffset = (EpochOffset)entry.getKey();
                Optional<RemoteLogSegmentMetadata> segmentMetadata = remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(epochOffset.epoch, epochOffset.offset);
                RemoteLogSegmentMetadata expectedSegmentMetadata = (RemoteLogSegmentMetadata)entry.getValue();
                log.debug("Searching for {} , result: {}, expected: {} ", new Object[]{epochOffset, segmentMetadata, expectedSegmentMetadata});
                if (expectedSegmentMetadata != null) {
                    Assertions.assertEquals(Optional.of(expectedSegmentMetadata), segmentMetadata);
                    continue;
                }
                Assertions.assertFalse((boolean)segmentMetadata.isPresent());
            }
            remoteLogSegmentLifecycleManager.updateRemoteLogSegmentMetadata(new RemoteLogSegmentMetadataUpdate(expectedSegment0Metadata.remoteLogSegmentId(), this.time.milliseconds(), RemoteLogSegmentState.DELETE_SEGMENT_STARTED, 1));
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 10L).isPresent());
            remoteLogSegmentLifecycleManager.updateRemoteLogSegmentMetadata(new RemoteLogSegmentMetadataUpdate(expectedSegment0Metadata.remoteLogSegmentId(), this.time.milliseconds(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, 1));
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 10L).isPresent());
            HashMap<Integer, Long> expectedEpochToHighestOffset = new HashMap<Integer, Long>();
            expectedEpochToHighestOffset.put(0, 19L);
            expectedEpochToHighestOffset.put(1, 79L);
            expectedEpochToHighestOffset.put(2, 239L);
            expectedEpochToHighestOffset.put(3, 369L);
            expectedEpochToHighestOffset.put(4, 400L);
            for (Map.Entry entry : expectedEpochToHighestOffset.entrySet()) {
                Integer epoch2 = (Integer)entry.getKey();
                Long expectedOffset = (Long)entry.getValue();
                Optional<Long> offset = remoteLogSegmentLifecycleManager.highestOffsetForEpoch(epoch2);
                log.debug("Fetching highest offset for epoch: {} , returned: {} , expected: {}", new Object[]{epoch2, offset, expectedOffset});
                Assertions.assertEquals(Optional.of(expectedOffset), offset);
            }
            Optional<Long> optional = remoteLogSegmentLifecycleManager.highestOffsetForEpoch(5);
            Assertions.assertFalse((boolean)optional.isPresent());
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    private RemoteLogSegmentMetadata createSegmentUpdateWithState(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager, Map<Integer, Long> segmentLeaderEpochs, long startOffset, long endOffset, RemoteLogSegmentState state) throws RemoteStorageException {
        RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.topicIdPartition, Uuid.randomUuid());
        RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, startOffset, endOffset, -1L, 0, this.time.milliseconds(), 0x100000, segmentLeaderEpochs);
        remoteLogSegmentLifecycleManager.addRemoteLogSegmentMetadata(segmentMetadata);
        RemoteLogSegmentMetadataUpdate segMetadataUpdate = new RemoteLogSegmentMetadataUpdate(segmentId, this.time.milliseconds(), state, 1);
        remoteLogSegmentLifecycleManager.updateRemoteLogSegmentMetadata(segMetadataUpdate);
        return segmentMetadata.createWithUpdates(segMetadataUpdate);
    }

    private static Collection<Arguments> remoteLogSegmentLifecycleManagers() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{new RemoteLogMetadataCacheWrapper()}), Arguments.of((Object[])new Object[]{new TopicBasedRemoteLogMetadataManagerWrapper()}));
    }

    private void checkListSegments(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager, int leaderEpoch, RemoteLogSegmentMetadata expectedSegment) throws RemoteStorageException {
        Iterator<RemoteLogSegmentMetadata> segmentsIter = remoteLogSegmentLifecycleManager.listRemoteLogSegments(leaderEpoch);
        Assertions.assertTrue((segmentsIter.hasNext() && Objects.equals(segmentsIter.next(), expectedSegment) ? 1 : 0) != 0);
        Iterator<RemoteLogSegmentMetadata> allSegmentsIter = remoteLogSegmentLifecycleManager.listAllRemoteLogSegments();
        Assertions.assertTrue((allSegmentsIter.hasNext() && Objects.equals(allSegmentsIter.next(), expectedSegment) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testCacheSegmentWithCopySegmentStartedState(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            RemoteLogSegmentId segmentId = new RemoteLogSegmentId(this.topicIdPartition, Uuid.randomUuid());
            RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, 0L, 50L, -1L, 0, this.time.milliseconds(), 0x100000, Collections.singletonMap(0, 0L));
            remoteLogSegmentLifecycleManager.addRemoteLogSegmentMetadata(segmentMetadata);
            Optional<RemoteLogSegmentMetadata> segMetadataForOffset0Epoch0 = remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 0L);
            Assertions.assertFalse((boolean)segMetadataForOffset0Epoch0.isPresent());
            this.checkListSegments(remoteLogSegmentLifecycleManager, 0, segmentMetadata);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testCacheSegmentWithCopySegmentFinishedState(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            RemoteLogSegmentMetadata segmentMetadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, Collections.singletonMap(0, 101L), 101L, 200L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            Optional<RemoteLogSegmentMetadata> segMetadataForOffset150 = remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 150L);
            Assertions.assertEquals(Optional.of(segmentMetadata), segMetadataForOffset150);
            this.checkListSegments(remoteLogSegmentLifecycleManager, 0, segmentMetadata);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testCacheSegmentWithDeleteSegmentStartedState(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            RemoteLogSegmentMetadata segmentMetadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, Collections.singletonMap(0, 201L), 201L, 300L, RemoteLogSegmentState.DELETE_SEGMENT_STARTED);
            Optional<RemoteLogSegmentMetadata> segmentMetadataForOffset250Epoch0 = remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 250L);
            Assertions.assertFalse((boolean)segmentMetadataForOffset250Epoch0.isPresent());
            this.checkListSegments(remoteLogSegmentLifecycleManager, 0, segmentMetadata);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testCacheSegmentsWithDeleteSegmentFinishedState(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            RemoteLogSegmentMetadata segmentMetadata = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, Collections.singletonMap(0, 301L), 301L, 400L, RemoteLogSegmentState.DELETE_SEGMENT_STARTED);
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.remoteLogSegmentMetadata(0, 350L).isPresent());
            RemoteLogSegmentMetadataUpdate segmentMetadataUpdate = new RemoteLogSegmentMetadataUpdate(segmentMetadata.remoteLogSegmentId(), this.time.milliseconds(), RemoteLogSegmentState.DELETE_SEGMENT_FINISHED, 1);
            remoteLogSegmentLifecycleManager.updateRemoteLogSegmentMetadata(segmentMetadataUpdate);
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.listRemoteLogSegments(0).hasNext());
            Assertions.assertFalse((boolean)remoteLogSegmentLifecycleManager.listAllRemoteLogSegments().hasNext());
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="remoteLogSegmentLifecycleManager = {0}")
    @MethodSource(value={"remoteLogSegmentLifecycleManagers"})
    public void testCacheListSegments(RemoteLogSegmentLifecycleManager remoteLogSegmentLifecycleManager) throws Exception {
        try {
            remoteLogSegmentLifecycleManager.initialize(this.topicIdPartition);
            RemoteLogSegmentMetadata segment0 = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, Collections.singletonMap(0, 0L), 0L, 100L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            RemoteLogSegmentMetadata segment1 = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, Collections.singletonMap(0, 101L), 101L, 200L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            HashMap<Integer, Long> segment2LeaderEpochs = new HashMap<Integer, Long>();
            segment2LeaderEpochs.put(0, 201L);
            segment2LeaderEpochs.put(1, 301L);
            RemoteLogSegmentMetadata segment2 = this.createSegmentUpdateWithState(remoteLogSegmentLifecycleManager, segment2LeaderEpochs, 201L, 400L, RemoteLogSegmentState.COPY_SEGMENT_FINISHED);
            List<RemoteLogSegmentMetadata> expectedSegmentsForEpoch0 = Arrays.asList(segment0, segment1, segment2);
            Assertions.assertTrue((boolean)TestUtils.sameElementsWithOrder(remoteLogSegmentLifecycleManager.listRemoteLogSegments(0), expectedSegmentsForEpoch0.iterator()));
            Assertions.assertTrue((boolean)TestUtils.sameElementsWithoutOrder(remoteLogSegmentLifecycleManager.listAllRemoteLogSegments(), expectedSegmentsForEpoch0.iterator()));
            List<RemoteLogSegmentMetadata> expectedSegmentsForEpoch1 = Collections.singletonList(segment2);
            Assertions.assertTrue((boolean)TestUtils.sameElementsWithOrder(remoteLogSegmentLifecycleManager.listRemoteLogSegments(1), expectedSegmentsForEpoch1.iterator()));
        }
        finally {
            Utils.closeQuietly((AutoCloseable)remoteLogSegmentLifecycleManager, (String)"RemoteLogSegmentLifecycleManager");
        }
    }

    static class RemoteLogMetadataCacheWrapper
    implements RemoteLogSegmentLifecycleManager {
        private final RemoteLogMetadataCache metadataCache = new RemoteLogMetadataCache();

        RemoteLogMetadataCacheWrapper() {
        }

        @Override
        public void updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate segmentMetadataUpdate) throws RemoteStorageException {
            this.metadataCache.updateRemoteLogSegmentMetadata(segmentMetadataUpdate);
        }

        @Override
        public Optional<Long> highestOffsetForEpoch(int epoch) {
            return this.metadataCache.highestOffsetForEpoch(epoch);
        }

        @Override
        public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(int leaderEpoch, long offset) {
            return this.metadataCache.remoteLogSegmentMetadata(leaderEpoch, offset);
        }

        @Override
        public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(int leaderEpoch) throws RemoteResourceNotFoundException {
            return this.metadataCache.listRemoteLogSegments(leaderEpoch);
        }

        @Override
        public Iterator<RemoteLogSegmentMetadata> listAllRemoteLogSegments() {
            return this.metadataCache.listAllRemoteLogSegments();
        }

        @Override
        public void addRemoteLogSegmentMetadata(RemoteLogSegmentMetadata segmentMetadata) {
            this.metadataCache.addCopyInProgressSegment(segmentMetadata);
        }
    }

    static class TopicBasedRemoteLogMetadataManagerWrapper
    extends TopicBasedRemoteLogMetadataManagerHarness
    implements RemoteLogSegmentLifecycleManager {
        private TopicIdPartition topicIdPartition;

        TopicBasedRemoteLogMetadataManagerWrapper() {
        }

        @Override
        public synchronized void initialize(TopicIdPartition topicIdPartition) {
            this.topicIdPartition = topicIdPartition;
            super.initialize(Collections.singleton(topicIdPartition), true);
        }

        @Override
        public void addRemoteLogSegmentMetadata(RemoteLogSegmentMetadata segmentMetadata) throws RemoteStorageException {
            try {
                this.remoteLogMetadataManager().addRemoteLogSegmentMetadata(segmentMetadata).get();
            }
            catch (Exception e) {
                throw new RemoteStorageException((Throwable)e);
            }
        }

        @Override
        public void updateRemoteLogSegmentMetadata(RemoteLogSegmentMetadataUpdate segmentMetadataUpdate) throws RemoteStorageException {
            try {
                this.remoteLogMetadataManager().updateRemoteLogSegmentMetadata(segmentMetadataUpdate).get();
            }
            catch (Exception e) {
                throw new RemoteStorageException((Throwable)e);
            }
        }

        @Override
        public Optional<Long> highestOffsetForEpoch(int leaderEpoch) throws RemoteStorageException {
            return this.remoteLogMetadataManager().highestOffsetForEpoch(this.topicIdPartition, leaderEpoch);
        }

        @Override
        public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(int leaderEpoch, long offset) throws RemoteStorageException {
            return this.remoteLogMetadataManager().remoteLogSegmentMetadata(this.topicIdPartition, leaderEpoch, offset);
        }

        @Override
        public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(int leaderEpoch) throws RemoteStorageException {
            return this.remoteLogMetadataManager().listRemoteLogSegments(this.topicIdPartition, leaderEpoch);
        }

        @Override
        public Iterator<RemoteLogSegmentMetadata> listAllRemoteLogSegments() throws RemoteStorageException {
            return this.remoteLogMetadataManager().listRemoteLogSegments(this.topicIdPartition);
        }

        @Override
        public void close() throws IOException {
            this.tearDown();
        }
    }

    private static class EpochOffset {
        final int epoch;
        final long offset;

        private EpochOffset(int epoch, long offset) {
            this.epoch = epoch;
            this.offset = offset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EpochOffset that = (EpochOffset)o;
            return this.epoch == that.epoch && this.offset == that.offset;
        }

        public int hashCode() {
            return Objects.hash(this.epoch, this.offset);
        }

        public String toString() {
            return "EpochOffset{epoch=" + this.epoch + ", offset=" + this.offset + '}';
        }
    }
}

