/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RemoteLogMetadataFormatterTest {
    private static final Uuid TOPIC_ID = Uuid.randomUuid();
    private static final String TOPIC = "foo";
    private static final TopicIdPartition TP0 = new TopicIdPartition(TOPIC_ID, new TopicPartition("foo", 0));
    private static final Uuid SEGMENT_ID = Uuid.randomUuid();

    @Test
    public void testFormat() throws IOException {
        HashMap<Integer, Long> segLeaderEpochs = new HashMap<Integer, Long>();
        segLeaderEpochs.put(0, 0L);
        segLeaderEpochs.put(1, 20L);
        segLeaderEpochs.put(2, 80L);
        RemoteLogSegmentId remoteLogSegmentId = new RemoteLogSegmentId(TP0, SEGMENT_ID);
        RemoteLogSegmentMetadata remoteLogMetadata = new RemoteLogSegmentMetadata(remoteLogSegmentId, 0L, 100L, -1L, 1, 123L, 1024, segLeaderEpochs);
        byte[] metadataBytes = new RemoteLogMetadataSerde().serialize((RemoteLogMetadata)remoteLogMetadata);
        ConsumerRecord metadataRecord = new ConsumerRecord("__remote_log_metadata", 0, 0L, null, (Object)metadataBytes);
        String expected = String.format("partition: 0, offset: 0, value: RemoteLogSegmentMetadata{remoteLogSegmentId=RemoteLogSegmentId{topicIdPartition=%s:foo-0, id=%s}, startOffset=0, endOffset=100, brokerId=1, maxTimestampMs=-1, eventTimestampMs=123, segmentLeaderEpochs={0=0, 1=20, 2=80}, segmentSizeInBytes=1024, state=COPY_SEGMENT_STARTED}\n", TOPIC_ID, SEGMENT_ID);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream ps = new PrintStream(baos);){
            RemoteLogMetadataSerde.RemoteLogMetadataFormatter formatter = new RemoteLogMetadataSerde.RemoteLogMetadataFormatter();
            formatter.writeTo(metadataRecord, ps);
            Assertions.assertEquals((Object)expected, (Object)baos.toString());
        }
    }
}

