/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.metadata.storage.FileBasedRemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileBasedRemoteLogMetadataCacheTest {
    @Test
    public void testFileBasedRemoteLogMetadataCacheWithUnreferencedSegments() throws Exception {
        TopicIdPartition partition = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("test", 0));
        int brokerId = 0;
        Path path = TestUtils.tempDirectory().toPath();
        FileBasedRemoteLogMetadataCache cache = new FileBasedRemoteLogMetadataCache(partition, path);
        RemoteLogSegmentId segmentId1 = new RemoteLogSegmentId(partition, Uuid.randomUuid());
        RemoteLogSegmentMetadata metadata1 = new RemoteLogSegmentMetadata(segmentId1, 0L, 100L, System.currentTimeMillis(), brokerId, System.currentTimeMillis(), 0x100000, Collections.singletonMap(0, 0L));
        cache.addCopyInProgressSegment(metadata1);
        RemoteLogSegmentMetadataUpdate metadataUpdate1 = new RemoteLogSegmentMetadataUpdate(segmentId1, System.currentTimeMillis(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, brokerId);
        cache.updateRemoteLogSegmentMetadata(metadataUpdate1);
        Optional receivedMetadata = cache.remoteLogSegmentMetadata(0, 0L);
        Assertions.assertTrue((boolean)receivedMetadata.isPresent());
        Assertions.assertEquals((Object)metadata1.createWithUpdates(metadataUpdate1), receivedMetadata.get());
        RemoteLogSegmentId segmentId2 = new RemoteLogSegmentId(partition, Uuid.randomUuid());
        RemoteLogSegmentMetadata metadata2 = new RemoteLogSegmentMetadata(segmentId2, 0L, 900L, System.currentTimeMillis(), brokerId, System.currentTimeMillis(), 0x100000, Collections.singletonMap(0, 0L));
        cache.addCopyInProgressSegment(metadata2);
        RemoteLogSegmentMetadataUpdate metadataUpdate2 = new RemoteLogSegmentMetadataUpdate(segmentId2, System.currentTimeMillis(), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, brokerId);
        cache.updateRemoteLogSegmentMetadata(metadataUpdate2);
        Optional receivedMetadata2 = cache.remoteLogSegmentMetadata(0, 0L);
        Assertions.assertTrue((boolean)receivedMetadata2.isPresent());
        Assertions.assertEquals((Object)metadata2.createWithUpdates(metadataUpdate2), receivedMetadata2.get());
        cache.flushToFile(0, Long.valueOf(0L));
        FileBasedRemoteLogMetadataCache loadedCache = new FileBasedRemoteLogMetadataCache(partition, path);
        Optional receivedMetadataAfterLoad = loadedCache.remoteLogSegmentMetadata(0, 0L);
        Assertions.assertTrue((boolean)receivedMetadataAfterLoad.isPresent());
        Assertions.assertEquals((Object)metadata2.createWithUpdates(metadataUpdate2), receivedMetadataAfterLoad.get());
    }
}

