/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RemoteLogSegmentMetadataTest {
    private static final TopicIdPartition TP0 = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));

    RemoteLogSegmentMetadataTest() {
    }

    @Test
    void createWithUpdates() {
        int brokerId = 0;
        int eventTimestamp = 0;
        int brokerIdFinished = 1;
        int timestampFinished = 1;
        long startOffset = 0L;
        long endOffset = 100L;
        int segmentSize = 123;
        long maxTimestamp = -1L;
        HashMap<Integer, Long> segmentLeaderEpochs = new HashMap<Integer, Long>();
        segmentLeaderEpochs.put(0, 0L);
        RemoteLogSegmentId segmentId = new RemoteLogSegmentId(TP0, Uuid.randomUuid());
        RemoteLogSegmentMetadata segmentMetadata = new RemoteLogSegmentMetadata(segmentId, startOffset, endOffset, maxTimestamp, brokerId, (long)eventTimestamp, segmentSize, segmentLeaderEpochs);
        RemoteLogSegmentMetadata.CustomMetadata customMetadata = new RemoteLogSegmentMetadata.CustomMetadata(new byte[]{0, 1, 2, 3});
        RemoteLogSegmentMetadataUpdate segmentMetadataUpdate = new RemoteLogSegmentMetadataUpdate(segmentId, (long)timestampFinished, Optional.of(customMetadata), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, brokerIdFinished);
        RemoteLogSegmentMetadata updatedMetadata = segmentMetadata.createWithUpdates(segmentMetadataUpdate);
        RemoteLogSegmentMetadata expectedUpdatedMetadata = new RemoteLogSegmentMetadata(segmentId, startOffset, endOffset, maxTimestamp, brokerIdFinished, (long)timestampFinished, segmentSize, Optional.of(customMetadata), RemoteLogSegmentState.COPY_SEGMENT_FINISHED, segmentLeaderEpochs);
        Assertions.assertEquals((Object)expectedUpdatedMetadata, (Object)updatedMetadata);
        Assertions.assertEquals((Object)segmentId, (Object)segmentMetadata.remoteLogSegmentId());
        Assertions.assertEquals((long)startOffset, (long)segmentMetadata.startOffset());
        Assertions.assertEquals((long)endOffset, (long)segmentMetadata.endOffset());
        Assertions.assertEquals((long)maxTimestamp, (long)segmentMetadata.maxTimestampMs());
        Assertions.assertEquals((int)brokerId, (int)segmentMetadata.brokerId());
        Assertions.assertEquals((long)eventTimestamp, (long)segmentMetadata.eventTimestampMs());
        Assertions.assertEquals((int)segmentSize, (int)segmentMetadata.segmentSizeInBytes());
        Assertions.assertEquals(segmentLeaderEpochs, (Object)segmentMetadata.segmentLeaderEpochs());
    }
}

