/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.confluent;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.raft.DefaultExternalKRaftMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class MetadataShellObserver
implements ClusterMetadataSource {
    private static final Logger log = LoggerFactory.getLogger(MetadataShellObserver.class);
    private final String quorumVoters;
    private final String clusterId;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Path tempDir;
    private final KRaftVersion kRaftVersion;
    private final VoterSet voterSet;

    static MetadataShellObserver create(String quorumVoters, String clusterId, Properties configProps) throws Exception {
        Path tempDir = Files.createTempDirectory("MetadataShell", new FileAttribute[0]);
        Exit.addShutdownHook((String)"delete-metadata-shell-temp-dir", () -> MetadataShellObserver.cleanup(null, tempDir));
        KafkaRaftManager raftManager = null;
        try {
            HashMap<String, String> configMap = new HashMap<String, String>();
            configProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> configMap.put(key.toString(), (String)value)));
            configMap.put("controller.quorum.voters", quorumVoters);
            configMap.put("process.roles", "broker");
            configMap.put("node.id", String.valueOf(Integer.MAX_VALUE));
            configMap.put("metadata.log.dir", tempDir.toAbsolutePath().toString());
            configMap.remove("log.dir");
            configMap.remove("log.dirs");
            configMap.putIfAbsent("controller.listener.names", "CONTROLLER");
            KafkaConfig config = new KafkaConfig(configMap);
            CompletableFuture<Map> votersFuture = CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((List)config.quorumConfig().voters()));
            raftManager = new KafkaRaftManager(clusterId, config, Uuid.ZERO_UUID, (RecordSerde)MetadataRecordSerde.INSTANCE, KafkaRaftServer.MetadataPartition(), KafkaRaftServer.MetadataTopicId(), Time.SYSTEM, new Metrics(), (ExternalKRaftMetrics)new DefaultExternalKRaftMetrics(Option.empty(), Option.empty()), OptionConverters.toScala(Optional.of("MetadataShellObserver")), votersFuture, (Collection)QuorumConfig.parseBootstrapServers((List)config.quorumConfig().bootstrapServers()), Endpoints.empty(), (FaultHandler)new LoggingFaultHandler("MetadataShellObserver", () -> {}), Optional.empty());
            AbstractMap.SimpleEntry<KRaftVersion, VoterSet> kRaftVersionAndVoterSet = MetadataShellObserver.getKRaftVersionAndVoterSet(raftManager.replicatedLog());
            return new MetadataShellObserver(quorumVoters, clusterId, (KafkaRaftManager<ApiMessageAndVersion>)raftManager, tempDir, kRaftVersionAndVoterSet.getKey(), kRaftVersionAndVoterSet.getValue());
        }
        catch (Throwable e) {
            MetadataShellObserver.cleanup(raftManager, tempDir);
            throw e;
        }
    }

    static void cleanup(KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir) {
        if (raftManager != null) {
            try {
                raftManager.shutdown();
            }
            catch (Exception e) {
                log.error("Got exception while shutting down raftManager", (Throwable)e);
            }
        }
        if (tempDir != null) {
            try {
                Utils.delete((File)tempDir.toFile());
            }
            catch (Exception e) {
                log.error("Got exception while removing temporary directory {}", (Throwable)e);
            }
        }
    }

    public MetadataShellObserver(String quorumVoters, String clusterId, KafkaRaftManager<ApiMessageAndVersion> raftManager, Path tempDir, KRaftVersion kRaftVersion, VoterSet voterSet) {
        this.quorumVoters = quorumVoters;
        this.clusterId = clusterId;
        this.raftManager = raftManager;
        this.tempDir = tempDir;
        this.kRaftVersion = kRaftVersion;
        this.voterSet = voterSet;
    }

    public void start(RaftClient.Listener<ApiMessageAndVersion> listener) throws Exception {
        this.raftManager.register(listener);
        this.raftManager.startup();
    }

    public OptionalLong highWaterMark() {
        OptionalLong result = this.raftManager.client().highWatermark();
        return result;
    }

    public void close() throws Exception {
        MetadataShellObserver.cleanup(this.raftManager, this.tempDir);
    }

    public String toString() {
        return "MetadataShellObserver(quorumVoters=" + this.quorumVoters + ", clusterId=" + this.clusterId + ")";
    }

    public KRaftVersion getKRaftVersion() {
        return this.kRaftVersion;
    }

    public VoterSet getVoterSet() {
        return this.voterSet;
    }

    public static AbstractMap.SimpleEntry<KRaftVersion, VoterSet> getKRaftVersionAndVoterSet(ReplicatedLog log) {
        KRaftControlRecordStateMachine partitionState = new KRaftControlRecordStateMachine(VoterSet.empty(), log, (RecordSerde)MetadataRecordSerde.INSTANCE, BufferSupplier.create(), 0x800000, new LogContext(), new KafkaRaftMetrics(new Metrics(), "raft"), (ExternalKRaftMetrics)new DefaultExternalKRaftMetrics(Option.empty(), Option.empty()));
        partitionState.updateState();
        KRaftVersion kRaftVersion = partitionState.lastKraftVersion();
        VoterSet voterSet = partitionState.lastVoterSet();
        return new AbstractMap.SimpleEntry<KRaftVersion, VoterSet>(kRaftVersion, voterSet);
    }
}

