/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.OptionalInt;
import org.apache.kafka.shell.command.LsCommandHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class LsCommandHandlerTest {
    @Test
    public void testCalculateColumnSchema() {
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(1, 3), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.empty(), List.of("abc", "def", "ghi")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(1, 2), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(0), List.of("abc", "def")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(3, 1).setColumnWidths(new Integer[]{3, 8, 6}), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(80), List.of("a", "abcdef", "beta")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(2, 3).setColumnWidths(new Integer[]{10, 7}), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(18), List.of("alphabet", "beta", "gamma", "theta", "zeta")));
    }

    @Test
    public void testPrintEntries() throws Exception {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                LsCommandHandler.printEntries((PrintWriter)writer, (String)"", (OptionalInt)OptionalInt.of(18), List.of("alphabet", "beta", "gamma", "theta", "zeta"));
            }
            Assertions.assertEquals((Object)String.join((CharSequence)String.format("%n", new Object[0]), List.of("alphabet  theta", "beta      zeta", "gamma")), (Object)stream.toString().trim());
        }
    }

    @Test
    public void testPrintTargets() throws Exception {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                LsCommandHandler.printTargets((PrintWriter)writer, (OptionalInt)OptionalInt.of(18), List.of("foo", "foobarbaz", "quux"), List.of(new LsCommandHandler.TargetDirectory("/some/dir", List.of("supercalifragalistic")), new LsCommandHandler.TargetDirectory("/some/other/dir", List.of("capability", "delegation", "elephant", "fungible", "green"))));
            }
            Assertions.assertEquals((Object)String.join((CharSequence)String.format("%n", new Object[0]), List.of("foo        quux", "foobarbaz  ", "", "/some/dir:", "supercalifragalistic", "", "/some/other/dir:", "capability", "delegation", "elephant", "fungible", "green")), (Object)stream.toString().trim());
        }
    }
}

