/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.shell.command.CatCommandHandler;
import org.apache.kafka.shell.command.CdCommandHandler;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.command.ErroneousCommandHandler;
import org.apache.kafka.shell.command.ExitCommandHandler;
import org.apache.kafka.shell.command.HelpCommandHandler;
import org.apache.kafka.shell.command.HistoryCommandHandler;
import org.apache.kafka.shell.command.LsCommandHandler;
import org.apache.kafka.shell.command.NoOpCommandHandler;
import org.apache.kafka.shell.command.PwdCommandHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class CommandTest {
    @Test
    public void testParseCommands() {
        Assertions.assertEquals((Object)new CatCommandHandler(List.of("foo")), (Object)new Commands(true).parseCommand(List.of("cat", "foo")));
        Assertions.assertEquals((Object)new CdCommandHandler(Optional.empty()), (Object)new Commands(true).parseCommand(List.of("cd")));
        Assertions.assertEquals((Object)new CdCommandHandler(Optional.of("foo")), (Object)new Commands(true).parseCommand(List.of("cd", "foo")));
        Assertions.assertEquals((Object)new ExitCommandHandler(), (Object)new Commands(true).parseCommand(List.of("exit")));
        Assertions.assertEquals((Object)new HelpCommandHandler(), (Object)new Commands(true).parseCommand(List.of("help")));
        Assertions.assertEquals((Object)new HistoryCommandHandler(3), (Object)new Commands(true).parseCommand(List.of("history", "3")));
        Assertions.assertEquals((Object)new HistoryCommandHandler(Integer.MAX_VALUE), (Object)new Commands(true).parseCommand(List.of("history")));
        Assertions.assertEquals((Object)new LsCommandHandler(List.of()), (Object)new Commands(true).parseCommand(List.of("ls")));
        Assertions.assertEquals((Object)new LsCommandHandler(List.of("abc", "123")), (Object)new Commands(true).parseCommand(List.of("ls", "abc", "123")));
        Assertions.assertEquals((Object)new PwdCommandHandler(), (Object)new Commands(true).parseCommand(List.of("pwd")));
    }

    @Test
    public void testParseInvalidCommand() {
        Assertions.assertEquals((Object)new ErroneousCommandHandler("invalid choice: 'blah' (choose from 'cat', 'cd', 'exit', 'find', 'help', 'history', 'ls', 'man', 'pwd', 'tree')"), (Object)new Commands(true).parseCommand(List.of("blah")));
    }

    @Test
    public void testEmptyCommandLine() {
        Assertions.assertEquals((Object)new NoOpCommandHandler(), (Object)new Commands(true).parseCommand(List.of("")));
        Assertions.assertEquals((Object)new NoOpCommandHandler(), (Object)new Commands(true).parseCommand(List.of()));
    }
}

