/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.raft.KafkaRaftManager;
import kafka.tools.TerseFailure;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.metadata.util.SnapshotFileReader;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.LoggingFaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.state.MetadataShellPublisher;
import org.apache.kafka.shell.state.MetadataShellState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataShell {
    private static final Logger log = LoggerFactory.getLogger(MetadataShell.class);
    private final MetadataShellState state = new MetadataShellState();
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final String snapshotPath;
    private final FaultHandler faultHandler;
    private final MetadataShellPublisher publisher;
    private FileLock fileLock;
    private SnapshotFileReader snapshotFileReader;
    private MetadataLoader loader;

    static File parent(File file) {
        File parent = file.getParentFile();
        return parent == null ? file : parent;
    }

    static File parentParent(File file) {
        return MetadataShell.parent(MetadataShell.parent(file));
    }

    static FileLock takeDirectoryLockIfExists(File directory) throws IOException {
        if (new File(directory, ".lock").exists()) {
            return MetadataShell.takeDirectoryLock(directory);
        }
        return null;
    }

    static FileLock takeDirectoryLock(File directory) throws IOException {
        FileLock fileLock = new FileLock(new File(directory, ".lock"));
        try {
            if (!fileLock.tryLock()) {
                throw new RuntimeException("Unable to lock " + directory.getAbsolutePath() + ". Please ensure that no broker or controller process is using this directory before proceeding.");
            }
        }
        catch (Throwable e) {
            fileLock.unlockAndClose();
            throw e;
        }
        return fileLock;
    }

    public MetadataShell(KafkaRaftManager<ApiMessageAndVersion> raftManager, String snapshotPath, FaultHandler faultHandler) {
        this.raftManager = raftManager;
        this.snapshotPath = snapshotPath;
        this.faultHandler = faultHandler;
        this.publisher = new MetadataShellPublisher(this.state);
        this.fileLock = null;
        this.snapshotFileReader = null;
    }

    private void initializeWithRaftManager() {
        this.raftManager.startup();
        this.loader = new MetadataLoader.Builder().setFaultHandler(this.faultHandler).setNodeId(-1).setHighWaterMarkAccessor(() -> this.raftManager.client().highWatermark()).build();
        this.raftManager.register((RaftClient.Listener)this.loader);
    }

    private void initializeWithSnapshotFileReader() throws Exception {
        this.fileLock = MetadataShell.takeDirectoryLockIfExists(MetadataShell.parentParent(new File(this.snapshotPath)));
        this.loader = new MetadataLoader.Builder().setFaultHandler(this.faultHandler).setNodeId(-1).setHighWaterMarkAccessor(() -> this.snapshotFileReader.highWaterMark()).build();
        this.snapshotFileReader = new SnapshotFileReader(this.snapshotPath, (RaftClient.Listener)this.loader);
        this.snapshotFileReader.startup();
    }

    public void run(List<String> args) throws Exception {
        if (this.raftManager != null) {
            if (this.snapshotPath != null) {
                throw new RuntimeException("Can't specify both a raft manager and snapshot file reader.");
            }
            this.initializeWithRaftManager();
        } else if (this.snapshotPath != null) {
            this.initializeWithSnapshotFileReader();
        } else {
            throw new RuntimeException("You must specify either a raft manager or a snapshot file reader.");
        }
        this.loader.installPublishers(Collections.singletonList(this.publisher)).get(15L, TimeUnit.MINUTES);
        if (args == null || args.isEmpty()) {
            System.out.println("Loading...");
            this.waitUntilCaughtUp();
            System.out.println("Starting...");
            try (InteractiveShell shell = new InteractiveShell(this.state);){
                shell.runMainLoop();
            }
        }
        this.waitUntilCaughtUp();
        Commands commands = new Commands(false);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));){
            Commands.Handler handler = commands.parseCommand(args);
            handler.run(Optional.empty(), writer, this.state);
            writer.flush();
        }
    }

    public void close() {
        Utils.closeQuietly((AutoCloseable)this.loader, (String)"loader");
        if (this.raftManager != null) {
            try {
                this.raftManager.shutdown();
            }
            catch (Exception e) {
                log.error("Error shutting down RaftManager", (Throwable)e);
            }
        }
        Utils.closeQuietly((AutoCloseable)this.snapshotFileReader, (String)"raftManager");
        if (this.fileLock != null) {
            try {
                this.fileLock.unlockAndClose();
            }
            catch (Exception e) {
                log.error("Error cleaning up fileLock", (Throwable)e);
            }
            finally {
                this.fileLock = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-shell").defaultHelp(true).description("The Apache Kafka metadata shell");
        parser.addArgument(new String[]{"--snapshot", "-s"}).type(String.class).help("The snapshot file to read.");
        parser.addArgument(new String[]{"command"}).nargs("*").help("The command to run.");
        Namespace res = parser.parseArgsOrFail(args);
        try {
            Builder builder = new Builder();
            builder.setSnapshotPath(res.getString("snapshot"));
            Path tempDir = Files.createTempDirectory("MetadataShell", new FileAttribute[0]);
            Exit.addShutdownHook((String)"agent-shutdown-hook", () -> {
                log.debug("Removing temporary directory " + tempDir.toAbsolutePath());
                try {
                    Utils.delete((File)tempDir.toFile());
                }
                catch (Exception e) {
                    log.error("Got exception while removing temporary directory " + tempDir.toAbsolutePath());
                }
            });
            try (MetadataShell shell = builder.build();){
                shell.run(res.getList("command"));
            }
            Exit.exit((int)0);
        }
        catch (TerseFailure e) {
            System.err.println("Error: " + e.getMessage());
            Exit.exit((int)1);
        }
        catch (Throwable e) {
            System.err.println("Unexpected error: " + (e.getMessage() == null ? "" : e.getMessage()));
            e.printStackTrace(System.err);
            Exit.exit((int)1);
        }
    }

    void waitUntilCaughtUp() throws InterruptedException {
        while (this.loader.lastAppliedOffset() <= 0L) {
            Thread.sleep(10L);
        }
        return;
    }

    public static class Builder {
        private KafkaRaftManager<ApiMessageAndVersion> raftManager = null;
        private String snapshotPath = null;
        private FaultHandler faultHandler = new LoggingFaultHandler("shell", () -> {});

        public Builder setRaftManager(KafkaRaftManager<ApiMessageAndVersion> raftManager) {
            this.raftManager = raftManager;
            return this;
        }

        public Builder setSnapshotPath(String snapshotPath) {
            this.snapshotPath = snapshotPath;
            return this;
        }

        public Builder setFaultHandler(FaultHandler faultHandler) {
            this.faultHandler = faultHandler;
            return this;
        }

        public MetadataShell build() {
            return new MetadataShell(this.raftManager, this.snapshotPath, this.faultHandler);
        }
    }
}

