/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.glob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.shell.glob.GlobVisitor;
import org.apache.kafka.shell.state.MetadataShellState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=5L, unit=TimeUnit.MINUTES)
public class GlobVisitorTest {
    private static final MetadataShellState DATA = new MetadataShellState(KafkaConfigSchema.EMPTY);

    @Test
    public void testStarGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("*", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "a"}, DATA.root().child("foo").child("a")), new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "beta"}, DATA.root().child("foo").child("beta")))), (Object)consumer.infos);
    }

    @Test
    public void testDotDot() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("..", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[0], DATA.root()))), (Object)consumer.infos);
    }

    @Test
    public void testDoubleDotDot() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../..", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[0], DATA.root()))), (Object)consumer.infos);
    }

    @Test
    public void testZGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../z*", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"zeta"}, DATA.root().child("zeta")), new GlobVisitor.MetadataNodeInfo(new String[]{"zzz"}, DATA.root().child("zzz")))), (Object)consumer.infos);
    }

    @Test
    public void testBetaOrThetaGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../*/{beta,theta}", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"alpha", "beta"}, DATA.root().child("alpha").child("beta")), new GlobVisitor.MetadataNodeInfo(new String[]{"alpha", "theta"}, DATA.root().child("alpha").child("theta")), new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "beta"}, DATA.root().child("foo").child("beta")))), (Object)consumer.infos);
    }

    @Test
    public void testNotFoundGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("epsilon", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.empty(), (Object)consumer.infos);
    }

    @Test
    public void testAbsoluteGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("/a?pha", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"alpha"}, DATA.root().child("alpha")))), (Object)consumer.infos);
    }

    static {
        DATA.setRoot((MetadataNode)new TestNode("", new TestNode("alpha", new TestNode("beta", new TestNode("gamma", new TestNode[0])), new TestNode("theta", new TestNode[0])), new TestNode("foo", new TestNode("a", new TestNode[0]), new TestNode("beta", new TestNode[0])), new TestNode("zeta", new TestNode("c", false)), new TestNode("zzz", new TestNode[0])));
        DATA.setWorkingDirectory("foo");
    }

    static class InfoConsumer
    implements Consumer<Optional<GlobVisitor.MetadataNodeInfo>> {
        private Optional<List<GlobVisitor.MetadataNodeInfo>> infos = null;

        InfoConsumer() {
        }

        @Override
        public void accept(Optional<GlobVisitor.MetadataNodeInfo> info) {
            if (this.infos == null) {
                if (info.isPresent()) {
                    this.infos = Optional.of(new ArrayList());
                    this.infos.get().add(info.get());
                } else {
                    this.infos = Optional.empty();
                }
            } else if (info.isPresent()) {
                this.infos.get().add(info.get());
            } else {
                throw new RuntimeException("Saw non-empty info after seeing empty info");
            }
        }
    }

    static class TestNode
    implements MetadataNode {
        private final String name;
        private final Map<String, TestNode> children;
        private final boolean isDirectory;

        TestNode(String name, boolean isDirectory) {
            this.name = name;
            this.children = new HashMap<String, TestNode>();
            this.isDirectory = isDirectory;
        }

        TestNode(String name, TestNode ... children) {
            this.name = name;
            this.children = new HashMap<String, TestNode>();
            for (TestNode child : children) {
                this.children.put(child.name, child);
            }
            this.isDirectory = true;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public Collection<String> childNames() {
            return this.children.keySet();
        }

        public MetadataNode child(String name) {
            return this.children.get(name);
        }
    }
}

