/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.state;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.shell.node.RootShellNode;

public class MetadataShellState {
    private final KafkaConfigSchema configSchema;
    private final AtomicLong numFaultsSeen;
    private volatile MetadataNode root;
    private volatile String workingDirectory;

    public MetadataShellState(KafkaConfigSchema configSchema) {
        this.configSchema = configSchema;
        this.numFaultsSeen = new AtomicLong(0L);
        this.root = new RootShellNode(MetadataImage.EMPTY);
        this.workingDirectory = "/";
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public AtomicLong numFaultsSeen() {
        return this.numFaultsSeen;
    }

    public MetadataNode root() {
        return this.root;
    }

    public void setRoot(MetadataNode root) {
        this.root = root;
    }

    public String workingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void visit(Consumer<MetadataShellState> consumer) {
        consumer.accept(this);
    }
}

