/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import kafka.utils.FileLock;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.shell.confluent.ShellSourceManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
@Tag(value="integration")
public class MetadataShellIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataShellIntegrationTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testLock(boolean canLock) throws Exception {
        block16: {
            try (IntegrationEnv env = new IntegrationEnv();){
                if (canLock) {
                    Assertions.assertThrows(NullPointerException.class, () -> new ShellSourceManager(null, null, null, Optional.of(env.tempDir)));
                    break block16;
                }
                FileLock fileLock = new FileLock(new File(env.tempDir, ".lock"));
                try {
                    fileLock.lock();
                    Assertions.assertEquals((Object)("Unable to lock " + env.tempDir.getAbsolutePath() + ". Please ensure that no broker or controller process is using this directory before proceeding."), (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new ShellSourceManager(null, null, null, Optional.of(new File(env.tempDir, "__cluster_metadata-0"))))).getMessage());
                }
                finally {
                    fileLock.destroy();
                }
            }
        }
    }

    static class IntegrationEnv
    implements AutoCloseable {
        File tempDir = Files.createTempDirectory("MetadataShellIntegrationTest", new FileAttribute[0]).toFile();

        IntegrationEnv() throws IOException {
        }

        @Override
        public void close() {
            if (this.tempDir != null) {
                try {
                    Utils.delete((File)this.tempDir);
                }
                catch (Throwable e) {
                    LOG.error("Error deleting tempDir", e);
                }
                finally {
                    this.tempDir = null;
                }
            }
        }
    }
}

