/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.shell.command.SnapshotCommandHandler;
import org.apache.kafka.shell.node.RootShellNode;
import org.apache.kafka.shell.state.MetadataShellState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SnapshotCommandHandlerTest {
    @ParameterizedTest
    @ValueSource(strings={"--output-dir", "-o"})
    public void testSnapshotGenerationWithDefaultId(String argument) throws Exception {
        Path tempDir = Files.createTempDirectory(Uuid.randomUuid().toString(), new FileAttribute[0]);
        SnapshotCommandHandler handler = this.newSnapshotCommandHandler(new String[]{argument, tempDir.toFile().toString()});
        MetadataImage image = this.emptyImageWithHighestOffsetAndEpoch(new OffsetAndEpoch(9L, 5));
        Path expectedPath = tempDir.resolve("00000000000000000010-0000000005.checkpoint");
        List<String> outputLines = this.runHandlerWithLoadedImage(handler, image, true);
        this.assertSuccessfulSnapshot(expectedPath, outputLines);
    }

    @Test
    public void testSnapshotGenerationWithSnapshotIdOverride() throws Exception {
        Path tempDir = Files.createTempDirectory(Uuid.randomUuid().toString(), new FileAttribute[0]);
        SnapshotCommandHandler handler = this.newSnapshotCommandHandler(new String[]{"--output-dir", tempDir.toFile().toString(), "--snapshot-id", "10001-16"});
        MetadataImage image = this.emptyImageWithHighestOffsetAndEpoch(new OffsetAndEpoch(9L, 5));
        Path expectedPath = tempDir.resolve("00000000000000010001-0000000016.checkpoint");
        List<String> outputLines = this.runHandlerWithLoadedImage(handler, image, true);
        this.assertSuccessfulSnapshot(expectedPath, outputLines);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "-f", "--force"})
    public void testSnapshotGenerationWithInvalidSnapshotIdOverride(String forceFlag) throws Exception {
        Path tempDir = Files.createTempDirectory(Uuid.randomUuid().toString(), new FileAttribute[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--output-dir", tempDir.toFile().toString(), "--snapshot-id", "500-5"));
        if (!forceFlag.isEmpty()) {
            args.add(forceFlag);
        }
        MetadataImage image = this.emptyImageWithHighestOffsetAndEpoch(new OffsetAndEpoch(200L, 10));
        Path expectedPath = tempDir.resolve("00000000000000000500-0000000005.checkpoint");
        SnapshotCommandHandler handler = this.newSnapshotCommandHandler(args.toArray(new String[0]));
        List<String> outputLines = this.runHandlerWithLoadedImage(handler, image, true);
        if (forceFlag.isEmpty()) {
            this.assertFailedSnapshot(expectedPath, outputLines, "Invalid snapshotId `OffsetAndEpoch(offset=500, epoch=5)`:");
        } else {
            this.assertSuccessfulSnapshot(expectedPath, outputLines);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"", "-f", "--force"})
    public void testSnapshotGenerationWithIncompleteLoadedImage(String forceFlag) throws Exception {
        Path tempDir = Files.createTempDirectory(Uuid.randomUuid().toString(), new FileAttribute[0]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("--output-dir", tempDir.toFile().toString()));
        if (!forceFlag.isEmpty()) {
            args.add(forceFlag);
        }
        MetadataImage image = this.emptyImageWithHighestOffsetAndEpoch(new OffsetAndEpoch(999L, 10));
        Path expectedPath = tempDir.resolve("00000000000000001000-0000000010.checkpoint");
        SnapshotCommandHandler handler = this.newSnapshotCommandHandler(args.toArray(new String[0]));
        List<String> outputLines = this.runHandlerWithLoadedImage(handler, image, false);
        if (forceFlag.isEmpty()) {
            this.assertFailedSnapshot(expectedPath, outputLines, "Cannot generate snapshot from an incomplete image:");
        } else {
            this.assertSuccessfulSnapshot(expectedPath, outputLines);
        }
    }

    @Test
    public void testDefaultArguments() throws ArgumentParserException {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Namespace ns = parser.parseArgs(new String[0]);
        Assertions.assertEquals((Object)".", (Object)ns.getString("output-dir"));
        Assertions.assertNull((Object)ns.get("snapshot-id"));
        Assertions.assertEquals((Object)false, (Object)ns.getBoolean("force"));
    }

    @Test
    public void testForceArgument() throws ArgumentParserException {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Assertions.assertEquals((Object)true, (Object)parser.parseArgs(new String[]{"-f"}).getBoolean("force"));
        Assertions.assertEquals((Object)true, (Object)parser.parseArgs(new String[]{"--force"}).getBoolean("force"));
    }

    @Test
    public void testValidSnapshotId() throws ArgumentParserException {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Namespace ns = parser.parseArgs(new String[]{"--snapshot-id", "15-20"});
        Assertions.assertEquals((Object)new OffsetAndEpoch(15L, 20), (Object)ns.get("snapshot-id"));
    }

    @ParameterizedTest
    @ValueSource(strings={"-15-20", "15--20", "15-foo", "foo-20", "foo", "15", "15-", "-20"})
    public void testInvalidSnapshotId(String invalidSnapshotId) {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Assertions.assertThrows(ArgumentParserException.class, () -> parser.parseArgs(new String[]{"--snapshot-id", invalidSnapshotId}));
    }

    @Test
    public void testValidOutputDir() throws IOException, ArgumentParserException {
        Path tempDir = Files.createTempDirectory(Uuid.randomUuid().toString(), new FileAttribute[0]);
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Namespace ns = parser.parseArgs(new String[]{"--output-dir", tempDir.toFile().toString()});
        Assertions.assertEquals((Object)tempDir.toFile().toString(), (Object)ns.getString("output-dir"));
    }

    @Test
    public void testNonExistingOutputDir() {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Assertions.assertThrows(ArgumentParserException.class, () -> parser.parseArgs(new String[]{"--output-dir", Uuid.randomUuid().toString()}));
    }

    @Test
    public void testNonDirOutputDir() throws IOException {
        Path tempFile = Files.createTempFile(Uuid.randomUuid().toString(), ".tmp", new FileAttribute[0]);
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Assertions.assertThrows(ArgumentParserException.class, () -> parser.parseArgs(new String[]{"--output-dir", tempFile.toFile().toString()}));
    }

    private ArgumentParser newParserWithSnapshotCommandHandler() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"test-shell");
        SnapshotCommandHandler.TYPE.addArguments(parser);
        return parser;
    }

    private SnapshotCommandHandler newSnapshotCommandHandler(String[] args) throws ArgumentParserException {
        ArgumentParser parser = this.newParserWithSnapshotCommandHandler();
        Namespace ns = parser.parseArgs(args);
        return SnapshotCommandHandler.TYPE.createHandler(ns);
    }

    private List<String> runHandlerWithLoadedImage(SnapshotCommandHandler handler, MetadataImage image, boolean isCompleteImage) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(outputStream);
        MetadataShellState state = new MetadataShellState(KafkaConfigSchema.EMPTY);
        if (!isCompleteImage) {
            state.numFaultsSeen().incrementAndGet();
        }
        state.setRoot((MetadataNode)new RootShellNode(image));
        handler.run(Optional.empty(), out, state);
        out.flush();
        return this.readLines(outputStream);
    }

    private List<String> readLines(ByteArrayOutputStream outputStream) throws IOException {
        String line;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private MetadataImage emptyImageWithHighestOffsetAndEpoch(OffsetAndEpoch highestOffsetAndEpoch) {
        return new MetadataImage(new MetadataProvenance(highestOffsetAndEpoch.offset(), highestOffsetAndEpoch.epoch(), 0L), FeaturesImage.EMPTY, ClusterImage.EMPTY, TopicsImage.EMPTY, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void assertSuccessfulSnapshot(Path expectedPath, List<String> outputLines) {
        Assertions.assertEquals((int)1, (int)outputLines.size());
        Assertions.assertEquals((Object)("Wrote snapshot: " + expectedPath.toAbsolutePath().toFile()), (Object)outputLines.get(0));
        Assertions.assertTrue((boolean)expectedPath.toFile().exists());
    }

    private void assertFailedSnapshot(Path expectedPath, List<String> outputLines, String errorMessagePrefix) {
        Assertions.assertEquals((int)1, (int)outputLines.size());
        Assertions.assertTrue((boolean)outputLines.get(0).startsWith(errorMessagePrefix));
        Assertions.assertFalse((boolean)expectedPath.toFile().exists());
    }
}

