/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.glob.GlobVisitor;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;

public final class FindCommandHandler
implements Commands.Handler {
    public static final Commands.Type TYPE = new FindCommandType();
    private final List<String> paths;

    public FindCommandHandler(List<String> paths) {
        this.paths = paths;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataShellState state) throws Exception {
        for (String path : CommandUtils.getEffectivePaths(this.paths)) {
            new GlobVisitor(path, entryOption -> {
                if (entryOption.isPresent()) {
                    this.find(writer, path, ((GlobVisitor.MetadataNodeInfo)entryOption.get()).node());
                } else {
                    writer.println("find: " + path + ": no such file or directory.");
                }
            }).accept(state);
        }
    }

    private void find(PrintWriter writer, String path, MetadataNode node) {
        writer.println(path);
        if (node.isDirectory()) {
            for (String name : node.childNames()) {
                String nextPath = path.equals("/") ? path + name : path + "/" + name;
                MetadataNode child = node.child(name);
                if (child == null) {
                    throw new RuntimeException("Expected " + name + " to be a valid child of " + path + ", but it was not.");
                }
                this.find(writer, nextPath, child);
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.paths);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FindCommandHandler)) {
            return false;
        }
        FindCommandHandler o = (FindCommandHandler)other;
        return Objects.equals(o.paths, this.paths);
    }

    public static class FindCommandType
    implements Commands.Type {
        private FindCommandType() {
        }

        @Override
        public String name() {
            return "find";
        }

        @Override
        public String description() {
            return "Search for nodes in the directory hierarchy.";
        }

        @Override
        public boolean shellOnly() {
            return false;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"paths"}).nargs("*").help("The paths to start at.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new FindCommandHandler(namespace.getList("paths"));
        }

        @Override
        public void completeNext(MetadataShellState state, List<String> nextWords, List<Candidate> candidates) throws Exception {
            CommandUtils.completePath(state, nextWords.get(nextWords.size() - 1), candidates);
        }
    }
}

