/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.shell.TrackingBatchReader;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingListener<T>
implements RaftClient.Listener<T> {
    private static final Logger log = LoggerFactory.getLogger(TrackingListener.class);
    private final CompletableFuture<Void> caughtUpFuture;
    private final Supplier<OptionalLong> highWaterMarkSupplier;
    private final RaftClient.Listener<T> underlying;

    public TrackingListener(CompletableFuture<Void> caughtUpFuture, Supplier<OptionalLong> highWaterMarkSupplier, RaftClient.Listener<T> underlying) {
        this.caughtUpFuture = caughtUpFuture;
        this.highWaterMarkSupplier = highWaterMarkSupplier;
        this.underlying = underlying;
    }

    public void handleCommit(BatchReader<T> reader) {
        TrackingBatchReader<T> trackingReader = new TrackingBatchReader<T>(reader);
        if (log.isTraceEnabled()) {
            log.trace("handleCommit(trackingReader.lastOffset={}, trackingReader.baseOffset={})", (Object)trackingReader.lastOffset(), (Object)trackingReader.baseOffset());
        }
        this.underlying.handleCommit(trackingReader);
        this.checkIfCaughtUp(trackingReader.lastOffset().getAsLong() + 1L);
    }

    public void handleSnapshot(SnapshotReader<T> reader) {
        if (log.isTraceEnabled()) {
            log.trace("handleSnapshot(reader.lastContainedLogOffset={})", (Object)reader.lastContainedLogOffset());
        }
        this.underlying.handleSnapshot(reader);
        this.checkIfCaughtUp(reader.lastContainedLogOffset() + 1L);
    }

    public void handleLeaderChange(LeaderAndEpoch leader) {
        if (log.isTraceEnabled()) {
            log.trace("handleLeaderChange(leader={})", (Object)leader);
        }
        this.underlying.handleLeaderChange(leader);
    }

    public void beginShutdown() {
        if (log.isTraceEnabled()) {
            log.trace("beginShutdown");
        }
        this.underlying.beginShutdown();
    }

    private void checkIfCaughtUp(long offset) {
        if (!this.caughtUpFuture.isDone()) {
            OptionalLong highWaterMarkOption = this.highWaterMarkSupplier.get();
            if (highWaterMarkOption.isPresent()) {
                long highWatermark = highWaterMarkOption.getAsLong();
                if (offset >= highWatermark) {
                    log.debug("Offset {} has caught up with high watermark {}.", (Object)offset, (Object)highWatermark);
                    this.caughtUpFuture.complete(null);
                } else {
                    log.debug("Offset {} has not yet caught up with high watermark {}.", (Object)offset, (Object)highWatermark);
                }
            } else {
                log.debug("High water mark is not known for RaftClient.");
            }
        }
    }
}

