/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class StoredRecordBatch {
    private final long baseOffset;
    private final List<ApiMessageAndVersion> records;
    private final long appendTimestamp;

    public static StoredRecordBatch fromRaftBatch(Batch<ApiMessageAndVersion> batch) {
        return new StoredRecordBatch(batch.baseOffset(), batch.records(), batch.appendTimestamp());
    }

    public StoredRecordBatch(long baseOffset, List<ApiMessageAndVersion> records, long appendTimestamp) {
        this.baseOffset = baseOffset;
        this.records = records;
        this.appendTimestamp = appendTimestamp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[offset ").append(this.baseOffset).append(" at ");
        builder.append(DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(this.appendTimestamp)));
        builder.append(String.format("]%n", new Object[0]));
        for (ApiMessageAndVersion messageAndVersion : this.records) {
            builder.append("    [").append(messageAndVersion.version()).append("] ");
            builder.append(messageAndVersion.message()).append(String.format("%n", new Object[0]));
        }
        return builder.toString();
    }
}

