/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.impl.type.FileArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.image.writer.RaftSnapshotWriter;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.MetadataNodeManager;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.jline.reader.Candidate;

public class SnapshotCommandHandler
implements Commands.Handler {
    public static final WriteSnapshotCommandType TYPE = new WriteSnapshotCommandType();
    static final String ATTR_OUTPUT_DIR = "output-dir";
    static final String ATTR_FORCE = "force";
    static final String ATTR_SNAPSHOT_ID = "snapshot-id";
    static final String ATTR_CONFIG_SCHEMA = "config-schema";
    private static final Pattern SNAPSHOT_ID_PATTERN = Pattern.compile("(\\d+)-(\\d+)");
    private static final int MAX_RECORDS_PER_BATCH = 1024;
    private final Optional<OffsetAndEpoch> snapshotId;
    private final File directory;
    private final KafkaConfigSchema configSchema;
    private final boolean forceSnapshotCreation;

    public SnapshotCommandHandler(Optional<OffsetAndEpoch> snapshotId, File directory, KafkaConfigSchema configSchema, boolean forceSnapshotCreation) {
        this.snapshotId = snapshotId;
        this.directory = directory;
        this.configSchema = configSchema;
        this.forceSnapshotCreation = forceSnapshotCreation;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter consoleWriter, MetadataNodeManager manager) throws Exception {
        if (manager.recordsSkippedDuringLoading() && !this.forceSnapshotCreation) {
            consoleWriter.println("Cannot generate snapshot from an incomplete image: the loaded image contains records that either could not be decrypted or encountered some error during loading. To override and generate a snapshot anyway, use the --force flag.");
            return;
        }
        MetadataNodeManager.LogListener listener = manager.logListener();
        MetadataImage image = listener.currentImage();
        OffsetAndEpoch imageOffsetAndEpoch = new OffsetAndEpoch(image.highestOffsetAndEpoch().offset() + 1L, image.highestOffsetAndEpoch().epoch());
        OffsetAndEpoch snapshotId = this.snapshotId.orElse(imageOffsetAndEpoch);
        if (snapshotId.compareTo(imageOffsetAndEpoch) < 0 && !this.forceSnapshotCreation) {
            consoleWriter.println("Invalid snapshotId `" + snapshotId + "`: the provided ID has a lower offset/epoch tuple than the latest from the loaded image `" + image.highestOffsetAndEpoch() + "`. To override and generate a snapshot with this ID anyway, use the --force flag.");
            return;
        }
        FileRawSnapshotWriter rawSnapshotWriter = FileRawSnapshotWriter.create((Path)this.directory.toPath(), (OffsetAndEpoch)snapshotId, Optional.empty());
        SnapshotWriter snapshotWriter = RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)rawSnapshotWriter, (int)0x800000, (MemoryPool)MemoryPool.NONE, (Time)Time.SYSTEM, (long)Time.SYSTEM.milliseconds(), (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);
        ImageWriterOptions options = new ImageWriterOptions.Builder().setMetadataVersion(image.features().metadataVersion()).setConfigSchema(this.configSchema).build();
        try (RaftSnapshotWriter imageWriter = new RaftSnapshotWriter(snapshotWriter, 1024);){
            image.write((ImageWriter)imageWriter, options);
            imageWriter.close(true);
        }
        consoleWriter.println("Wrote snapshot: " + rawSnapshotWriter.targetSnapshotPath().toAbsolutePath().toFile());
    }

    static class SnapshotIdArgumentType
    implements ArgumentType<OffsetAndEpoch> {
        SnapshotIdArgumentType() {
        }

        public OffsetAndEpoch convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
            Matcher matcher = SNAPSHOT_ID_PATTERN.matcher(value);
            if (!matcher.matches()) {
                this.throwArgumentParserException(parser, value);
            }
            try {
                long offset = Long.parseLong(matcher.group(1));
                int epoch = Integer.parseInt(matcher.group(2));
                return new OffsetAndEpoch(offset, epoch);
            }
            catch (Throwable t) {
                this.throwArgumentParserException(parser, value);
                return null;
            }
        }

        private void throwArgumentParserException(ArgumentParser parser, Object value) throws ArgumentParserException {
            throw new ArgumentParserException("Invalid snapshot ID: `" + value + "`. Must be in the form of `{offset}-{epoch}`.", parser);
        }
    }

    public static class WriteSnapshotCommandType
    implements Commands.Type {
        @Override
        public String name() {
            return "write-snapshot";
        }

        @Override
        public String description() {
            return "Take a snapshot of the current loaded image";
        }

        @Override
        public boolean shellOnly() {
            return true;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"-o", "--output-directory"}).dest(SnapshotCommandHandler.ATTR_OUTPUT_DIR).type((ArgumentType)new FileArgumentType().verifyExists().verifyIsDirectory().verifyCanWrite()).required(false).setDefault((Object)".").nargs("?").help("Output directory for the generated snapshot (if not provided, the snapshot will be written in the current working directory)");
            parser.addArgument(new String[]{"-f", "--force"}).dest(SnapshotCommandHandler.ATTR_FORCE).action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false).help("Force snapshot generation for an image that was loaded incompletely (i.e. some records were skipped when loading the image from disk).");
            parser.addArgument(new String[]{"--snapshot-id"}).dest(SnapshotCommandHandler.ATTR_SNAPSHOT_ID).required(false).type((ArgumentType)new SnapshotIdArgumentType()).nargs("?").help("The snapshot ID of the generated snapshot in the form of `{offset}-{epoch}`. The provided ID must be larger than the last seen offset/epoch from the consumed log data (use `--force` to override this behavior). If not provided, the ID will take the largest offset/epoch read during loading.");
        }

        @Override
        public SnapshotCommandHandler createHandler(Namespace namespace) {
            return new SnapshotCommandHandler(Optional.ofNullable(namespace.get(SnapshotCommandHandler.ATTR_SNAPSHOT_ID)), new File(namespace.getString(SnapshotCommandHandler.ATTR_OUTPUT_DIR)), (KafkaConfigSchema)namespace.get(SnapshotCommandHandler.ATTR_CONFIG_SCHEMA), namespace.getBoolean(SnapshotCommandHandler.ATTR_FORCE));
        }

        @Override
        public void completeNext(MetadataNodeManager nodeManager, List<String> nextWords, List<Candidate> candidates) throws Exception {
        }
    }
}

