/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.shell.CommandUtils;
import org.apache.kafka.shell.GlobComponent;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.MetadataNodeManager;

public final class GlobVisitor
implements Consumer<MetadataNodeManager.Data> {
    private final String glob;
    private final Consumer<Optional<MetadataNodeInfo>> handler;

    public GlobVisitor(String glob, Consumer<Optional<MetadataNodeInfo>> handler) {
        this.glob = glob;
        this.handler = handler;
    }

    @Override
    public void accept(MetadataNodeManager.Data data) {
        String fullGlob = this.glob.startsWith("/") ? this.glob : data.workingDirectory() + "/" + this.glob;
        List<String> globComponents = CommandUtils.stripDotPathComponents(CommandUtils.splitPath(fullGlob));
        if (!this.accept(globComponents, 0, data.root(), new String[0])) {
            this.handler.accept(Optional.empty());
        }
    }

    private boolean accept(List<String> globComponents, int componentIndex, MetadataNode node, String[] path) {
        if (componentIndex >= globComponents.size()) {
            this.handler.accept(Optional.of(new MetadataNodeInfo(path, node)));
            return true;
        }
        String globComponentString = globComponents.get(componentIndex);
        GlobComponent globComponent = new GlobComponent(globComponentString);
        if (globComponent.literal()) {
            if (!(node instanceof MetadataNode.DirectoryNode)) {
                return false;
            }
            MetadataNode.DirectoryNode directory = (MetadataNode.DirectoryNode)node;
            MetadataNode child = directory.child(globComponent.component());
            if (child == null) {
                return false;
            }
            String[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[path.length] = globComponent.component();
            return this.accept(globComponents, componentIndex + 1, child, newPath);
        }
        if (!(node instanceof MetadataNode.DirectoryNode)) {
            return false;
        }
        MetadataNode.DirectoryNode directory = (MetadataNode.DirectoryNode)node;
        boolean matchedAny = false;
        for (Map.Entry entry : directory.children().entrySet()) {
            String nodeName = (String)entry.getKey();
            if (!globComponent.matches(nodeName)) continue;
            String[] newPath = new String[path.length + 1];
            System.arraycopy(path, 0, newPath, 0, path.length);
            newPath[path.length] = nodeName;
            if (!this.accept(globComponents, componentIndex + 1, (MetadataNode)entry.getValue(), newPath)) continue;
            matchedAny = true;
        }
        return matchedAny;
    }

    public static class MetadataNodeInfo {
        private final String[] path;
        private final MetadataNode node;

        MetadataNodeInfo(String[] path, MetadataNode node) {
            this.path = path;
            this.node = node;
        }

        public String[] path() {
            return this.path;
        }

        public MetadataNode node() {
            return this.node;
        }

        public String lastPathComponent() {
            if (this.path.length == 0) {
                return "/";
            }
            return this.path[this.path.length - 1];
        }

        public String absolutePath() {
            return "/" + String.join((CharSequence)"/", this.path);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.node);
        }

        public boolean equals(Object o) {
            if (!(o instanceof MetadataNodeInfo)) {
                return false;
            }
            MetadataNodeInfo other = (MetadataNodeInfo)o;
            if (!Arrays.equals(this.path, other.path)) {
                return false;
            }
            return this.node.equals(other.node);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder("MetadataNodeInfo(path=");
            for (int i = 0; i < this.path.length; ++i) {
                bld.append("/");
                bld.append(this.path[i]);
            }
            bld.append(", node=").append(this.node).append(")");
            return bld.toString();
        }
    }
}

