/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobComponent {
    private static final Logger log = LoggerFactory.getLogger(GlobComponent.class);
    private final String component;
    private final Pattern pattern;

    private static boolean isRegularExpressionSpecialCharacter(char ch) {
        switch (ch) {
            case '$': 
            case '(': 
            case ')': 
            case '+': 
            case '.': 
            case '[': 
            case ']': 
            case '^': 
            case '{': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    private static boolean isGlobSpecialCharacter(char ch) {
        switch (ch) {
            case '*': 
            case '?': 
            case '\\': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    static String toRegularExpression(String glob) {
        StringBuilder output = new StringBuilder("^");
        boolean literal = true;
        boolean processingGroup = false;
        int i = 0;
        block8: while (i < glob.length()) {
            char c = glob.charAt(i++);
            switch (c) {
                case '?': {
                    literal = false;
                    output.append(".");
                    continue block8;
                }
                case '*': {
                    literal = false;
                    output.append(".*");
                    continue block8;
                }
                case '\\': {
                    if (i == glob.length()) {
                        output.append(c);
                        continue block8;
                    }
                    char next = glob.charAt(i);
                    ++i;
                    if (GlobComponent.isGlobSpecialCharacter(next) || GlobComponent.isRegularExpressionSpecialCharacter(next)) {
                        output.append('\\');
                    }
                    output.append(next);
                    continue block8;
                }
                case '{': {
                    if (processingGroup) {
                        throw new RuntimeException("Can't nest glob groups.");
                    }
                    literal = false;
                    output.append("(?:(?:");
                    processingGroup = true;
                    continue block8;
                }
                case ',': {
                    if (processingGroup) {
                        literal = false;
                        output.append(")|(?:");
                        continue block8;
                    }
                    output.append(c);
                    continue block8;
                }
                case '}': {
                    if (processingGroup) {
                        literal = false;
                        output.append("))");
                        processingGroup = false;
                        continue block8;
                    }
                    output.append(c);
                    continue block8;
                }
            }
            if (GlobComponent.isRegularExpressionSpecialCharacter(c)) {
                output.append('\\');
            }
            output.append(c);
        }
        if (processingGroup) {
            throw new RuntimeException("Unterminated glob group.");
        }
        if (literal) {
            return null;
        }
        output.append('$');
        return output.toString();
    }

    public GlobComponent(String component) {
        this.component = component;
        Pattern newPattern = null;
        try {
            String regularExpression = GlobComponent.toRegularExpression(component);
            if (regularExpression != null) {
                newPattern = Pattern.compile(regularExpression);
            }
        }
        catch (RuntimeException e) {
            log.debug("Invalid glob pattern: " + e.getMessage());
        }
        this.pattern = newPattern;
    }

    public String component() {
        return this.component;
    }

    public boolean literal() {
        return this.pattern == null;
    }

    public boolean matches(String nodeName) {
        if (this.pattern == null) {
            return this.component.equals(nodeName);
        }
        return this.pattern.matcher(nodeName).matches();
    }
}

