/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;

class TrackingBatchReader<T>
implements BatchReader<T> {
    private final BatchReader<T> underlying;
    private final List<Batch<T>> batches;
    private final Iterator<Batch<T>> iter;

    TrackingBatchReader(BatchReader<T> underlying) {
        this.underlying = underlying;
        this.batches = new ArrayList<Batch<T>>();
        while (underlying.hasNext()) {
            this.batches.add((Batch<T>)underlying.next());
        }
        this.iter = this.batches.iterator();
    }

    public long baseOffset() {
        return this.underlying.baseOffset();
    }

    public OptionalLong lastOffset() {
        if (this.batches.isEmpty()) {
            return OptionalLong.of(-1L);
        }
        return OptionalLong.of(this.batches.get(this.batches.size() - 1).lastOffset());
    }

    public void close() {
        this.underlying.close();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Batch<T> next() {
        return this.iter.next();
    }
}

