/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.MetadataNodeManager;

public final class NonInteractiveShell
implements AutoCloseable {
    private final ClusterMetadataSource source;
    private final Commands commands;
    private final MetadataNodeManager nodeManager;

    public NonInteractiveShell(ClusterMetadataSource source, Commands commands) throws Exception {
        this.source = source;
        this.commands = commands;
        this.nodeManager = new MetadataNodeManager();
        this.nodeManager.setup(source);
        source.start((ClusterMetadataSource.Listener)this.nodeManager.logListener());
    }

    public NonInteractiveShell(ClusterMetadataSource source) throws Exception {
        this(source, new Commands(true));
    }

    public void run(OutputStream out, List<String> command) throws Exception {
        this.source.caughtUpFuture().get();
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));){
            Commands.Handler handler = this.commands.parseCommand(command);
            handler.run(Optional.empty(), writer, this.nodeManager);
            writer.flush();
        }
    }

    @Override
    public void close() throws Exception {
        Utils.closeQuietly((AutoCloseable)this.source, (String)"source");
        Utils.closeQuietly((AutoCloseable)this.nodeManager, (String)"nodeManager");
    }
}

