/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.PartitionRecordJsonConverter;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.util.ClusterMetadataSource;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.StoredRecordBatch;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataNodeManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MetadataNodeManager.class);
    private final Data data = new Data();
    private final LogListener logListener = new LogListener();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final KafkaEventQueue queue;
    private volatile MetadataDelta delta;

    public MetadataNodeManager() {
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.queue = new KafkaEventQueue(Time.SYSTEM, new LogContext("[node-manager-event-queue] "), "");
        this.delta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
    }

    public void setup(Object source) throws Exception {
        CompletableFuture future = new CompletableFuture();
        this.appendEvent("createShellNodes", () -> {
            MetadataNode.DirectoryNode directory = this.data.root().mkdirs("shell");
            directory.create("release").setContents(AppInfoParser.getVersion());
            directory.create("commitId").setContents(AppInfoParser.getCommitId());
            directory.create("source").setContents(source);
            this.data.root().mkdirs("brokers");
            this.data.root().mkdirs("configs");
            this.data.root().mkdirs("features");
            this.data.root().mkdirs("topics");
            this.data.root().mkdirs("topicIds");
            future.complete(null);
        }, future);
        future.get();
    }

    public LogListener logListener() {
        return this.logListener;
    }

    Data getData() {
        return this.data;
    }

    @Override
    public void close() throws Exception {
        this.queue.close();
    }

    public void visit(Consumer<Data> consumer) throws Exception {
        CompletableFuture future = new CompletableFuture();
        this.appendEvent("visit", () -> {
            consumer.accept(this.data);
            future.complete(null);
        }, future);
        future.get();
    }

    private void appendEvent(final String name, final Runnable runnable, final CompletableFuture<?> future) {
        this.queue.append(new EventQueue.Event(){

            public void run() throws Exception {
                runnable.run();
            }

            public void handleException(Throwable e) {
                log.error("Unexpected error while handling event " + name, e);
                if (future != null) {
                    future.completeExceptionally(e);
                }
            }
        });
    }

    public void refreshNodes() {
        MetadataImage image = this.delta.apply();
        this.delta = new MetadataDelta(image, __ -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        HashSet children = new HashSet(this.data.root.children().keySet());
        children.forEach(arg_0 -> MetadataNodeManager.lambda$refreshNodes$4(this.data.root, arg_0));
        class CollectingSnapshotConsumer
        implements Consumer<List<ApiMessageAndVersion>> {
            private final List<List<ApiMessageAndVersion>> batches = new ArrayList<List<ApiMessageAndVersion>>();

            CollectingSnapshotConsumer() {
            }

            @Override
            public void accept(List<ApiMessageAndVersion> batch) {
                this.batches.add(batch);
            }

            public List<List<ApiMessageAndVersion>> batches() {
                return this.batches;
            }
        }
        CollectingSnapshotConsumer writerClientQuotas = new CollectingSnapshotConsumer();
        image.clientQuotas().write((Consumer)writerClientQuotas);
        for (List<ApiMessageAndVersion> clientBatch : writerClientQuotas.batches()) {
            Iterator<ApiMessageAndVersion> iterator = clientBatch.iterator();
            if (!iterator.hasNext()) continue;
            ApiMessageAndVersion messageClient = iterator.next();
            ClientQuotaRecord clientQuotaRecord = (ClientQuotaRecord)messageClient.message();
            Iterator<List<ApiMessageAndVersion>> directoriesClientQuotas = MetadataNodeManager.clientQuotaRecordDirectories(clientQuotaRecord.entity());
            MetadataNode.DirectoryNode nodeClientQuotas = this.data.root;
            Iterator<String> iterator2 = directoriesClientQuotas.iterator();
            while (iterator2.hasNext()) {
                String dirClientQuotas = iterator2.next();
                nodeClientQuotas = nodeClientQuotas.mkdirs(dirClientQuotas);
            }
            if (clientQuotaRecord.remove()) {
                nodeClientQuotas.rmrf(clientQuotaRecord.key());
                continue;
            }
            nodeClientQuotas.create(clientQuotaRecord.key()).setContents(clientQuotaRecord.value() + "");
        }
        MetadataNode.DirectoryNode producerIdsDirectory = this.data.root.mkdirs("producerIds");
        producerIdsDirectory.create("nextBlockStartId").setContents(String.valueOf(image.producerIds().highestSeenProducerId()));
        MetadataNode.DirectoryNode aclsById = this.data.root.mkdirs("acls", "by-id");
        CollectingSnapshotConsumer writerAcls = new CollectingSnapshotConsumer();
        image.acls().write((Consumer)writerAcls);
        for (List list : writerAcls.batches()) {
            for (ApiMessageAndVersion messageAcls : list) {
                AccessControlEntryRecord recordAcls = (AccessControlEntryRecord)messageAcls.message();
                StandardAcl acl = StandardAcl.fromRecord((AccessControlEntryRecord)recordAcls);
                aclsById.create(recordAcls.id().toString()).setContents(acl);
                List<String> aclsByTypeDirectory = MetadataNodeManager.aclPath(recordAcls.resourceType(), recordAcls.patternType(), recordAcls.resourceName(), recordAcls.id());
                MetadataNode.DirectoryNode node = this.data.root;
                for (String directory : aclsByTypeDirectory) {
                    node = node.mkdirs(directory);
                }
                node.create(recordAcls.id().toString()).setContents(acl);
            }
        }
        MetadataNode.DirectoryNode configsDirectory = this.data.root.mkdirs("configs");
        CollectingSnapshotConsumer collectingSnapshotConsumer = new CollectingSnapshotConsumer();
        image.configs().write((Consumer)collectingSnapshotConsumer, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE, KafkaConfigSchema.EMPTY);
        for (List<ApiMessageAndVersion> configBatch : collectingSnapshotConsumer.batches()) {
            for (ApiMessageAndVersion messageConfig : configBatch) {
                ConfigRecord recordConfigs = (ConfigRecord)messageConfig.message();
                String typeString = "";
                switch (ConfigResource.Type.forId((byte)recordConfigs.resourceType())) {
                    case BROKER: {
                        typeString = "broker";
                        break;
                    }
                    case TOPIC: {
                        typeString = "topic";
                        break;
                    }
                    case CLUSTER_LINK: {
                        typeString = "cluster-link";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Error processing CONFIG_RECORD: Can't handle ConfigResource.Type " + recordConfigs.resourceType());
                    }
                }
                configsDirectory.mkdirs(typeString).mkdirs(recordConfigs.resourceName()).create(recordConfigs.name()).setContents(recordConfigs.value());
            }
        }
        MetadataNode.DirectoryNode metadataQuorumDirectory = this.data.root.mkdirs("metadataQuorum");
        metadataQuorumDirectory.create("offset").setContents(String.valueOf(image.highestOffsetAndEpoch().offset - 1L));
        MetadataNode.DirectoryNode brokersDir = this.data.root.mkdirs("brokers");
        image.cluster().brokers().forEach((brokerId, brokerReg) -> {
            MetadataNode.DirectoryNode brokerDir = brokersDir.mkdirs(String.valueOf(brokerId));
            brokerDir.create("isFenced").setContents(String.valueOf(brokerReg.fenced()));
            RegisterBrokerRecord brokRecord = (RegisterBrokerRecord)brokerReg.toRecord(image.features().metadataVersion()).message();
            brokerDir.create("registration").setContents(String.valueOf(brokRecord));
        });
        MetadataNode.DirectoryNode topicsNamesDir = this.data.root.mkdirs("topics");
        MetadataNode.DirectoryNode topicsIdsDir = this.data.root.mkdirs("topicIds");
        image.topics().topicsById().forEach((name, topic) -> this.handlePartitions(String.valueOf(name), (TopicImage)topic, topicsIdsDir));
        image.topics().topicsByName().forEach((name, topic) -> this.handlePartitions((String)name, (TopicImage)topic, topicsNamesDir));
    }

    private void handlePartitions(String name, TopicImage topic, MetadataNode.DirectoryNode node) {
        MetadataNode.DirectoryNode nameNode = node.mkdirs(name);
        nameNode.create("id").setContents(String.valueOf(topic.id()));
        nameNode.create("name").setContents(topic.name());
        topic.partitions().forEach((id, value) -> {
            MetadataNode.DirectoryNode partitionNode = nameNode.mkdirs(String.valueOf(id));
            PartitionRecord record = (PartitionRecord)value.toRecord(topic.id(), id.intValue()).message();
            JsonNode json = PartitionRecordJsonConverter.write((PartitionRecord)record, (short)0);
            partitionNode.create("data").setContents(json.toPrettyString());
        });
    }

    void handleMessage(ApiMessage message, long offset, int epoch) {
        try {
            this.delta.replay(offset, epoch, message);
        }
        catch (Exception e) {
            log.error("Error processing record of type " + message.apiKey() + " at offset " + offset, (Throwable)e);
        }
    }

    static List<String> aclPath(byte resourceType, byte patternType, String resourceName, Uuid id) {
        return MetadataNodeManager.aclPath(ResourceType.fromCode((byte)resourceType), PatternType.fromCode((byte)patternType), resourceName, id);
    }

    static List<String> aclPath(ResourceType resourceType, PatternType patternType, String resourceName, Uuid id) {
        ArrayList<String> results = new ArrayList<String>();
        results.add("acls");
        results.add("by-type");
        if (resourceType.isUnknown()) {
            throw new RuntimeException("Unable to identify a valid ACL resource type for ACL " + id.toString());
        }
        results.add(resourceType.toString().toLowerCase(Locale.ROOT));
        switch (patternType) {
            case LITERAL: {
                if (resourceName.equals("*")) {
                    results.add("wildcard");
                    break;
                }
                results.add("literal");
                results.add(resourceName);
                break;
            }
            case PREFIXED: {
                results.add("prefixed");
                results.add(resourceName);
                break;
            }
            default: {
                throw new RuntimeException("Unable to identify a valid ACL pattern type for ACL " + id.toString());
            }
        }
        return results;
    }

    static List<String> clientQuotaRecordDirectories(List<ClientQuotaRecord.EntityData> entityData) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("client-quotas");
        TreeMap entries = new TreeMap();
        entityData.forEach(e -> entries.put(e.entityType(), e));
        for (Map.Entry entry : entries.entrySet()) {
            result.add((String)entry.getKey());
            result.add(((ClientQuotaRecord.EntityData)entry.getValue()).entityName() == null ? "<default>" : ((ClientQuotaRecord.EntityData)entry.getValue()).entityName());
        }
        return result;
    }

    private static /* synthetic */ void lambda$refreshNodes$4(MetadataNode.DirectoryNode rec$, String xva$0) {
        rec$.rmrf(xva$0);
    }

    public class LogListener
    implements ClusterMetadataSource.Listener<ApiMessageAndVersion> {
        public void refreshNodes() {
            MetadataNodeManager.this.refreshNodes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
            try {
                while (reader.hasNext()) {
                    Batch batch = (Batch)reader.next();
                    log.debug("handleCommits " + batch.records() + " at offset " + batch.lastOffset());
                    MetadataNode.DirectoryNode dir = MetadataNodeManager.this.data.root.mkdirs("metadataQuorum");
                    int recordInBatch = 0;
                    dir.create("offset").setContents(String.valueOf(batch.lastOffset()));
                    for (ApiMessageAndVersion messageAndVersion : batch.records()) {
                        MetadataRecordType type = MetadataRecordType.fromId((short)messageAndVersion.message().apiKey());
                        if (type == MetadataRecordType.INSTALL_METADATA_ENCRYPTOR_RECORD || type == MetadataRecordType.ENCRYPTED_ENVELOPE_RECORD) {
                            log.warn("Skipping {} at offset {}", (Object)type, (Object)(batch.baseOffset() + (long)recordInBatch));
                            ++recordInBatch;
                            continue;
                        }
                        MetadataNodeManager.this.handleMessage(messageAndVersion.message(), batch.baseOffset() + (long)recordInBatch, batch.epoch());
                        ++recordInBatch;
                    }
                    dir.mkdirs("log").create(String.format("%07d", batch.baseOffset())).setContents(StoredRecordBatch.fromRaftBatch((Batch<ApiMessageAndVersion>)batch));
                }
            }
            finally {
                reader.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
            try {
                MetadataNode.DirectoryNode dir = MetadataNodeManager.this.data.root.mkdirs("metadataQuorum");
                dir.rmrf("snapshot");
                while (reader.hasNext()) {
                    Batch batch = (Batch)reader.next();
                    log.trace("handling new snapshot {} batch {}", (Object)reader.snapshotId(), (Object)batch);
                    int recordInBatch = 0;
                    for (ApiMessageAndVersion messageAndVersion : batch) {
                        MetadataRecordType type = MetadataRecordType.fromId((short)messageAndVersion.message().apiKey());
                        if (type == MetadataRecordType.INSTALL_METADATA_ENCRYPTOR_RECORD || type == MetadataRecordType.ENCRYPTED_ENVELOPE_RECORD) {
                            log.warn("Skipping {} at offset {}", (Object)type, (Object)(batch.baseOffset() + (long)recordInBatch));
                            ++recordInBatch;
                            continue;
                        }
                        MetadataNodeManager.this.handleMessage(messageAndVersion.message(), batch.baseOffset() + (long)recordInBatch, batch.epoch());
                        ++recordInBatch;
                    }
                    dir.mkdirs("snapshot").create("" + batch.baseOffset()).setContents(StoredRecordBatch.fromRaftBatch((Batch<ApiMessageAndVersion>)batch));
                }
            }
            finally {
                log.trace("closing snapshot reader for snapshot {}", (Object)reader.snapshotId());
                reader.close();
            }
        }

        public void handleLeaderChange(LeaderAndEpoch leader) {
            MetadataNodeManager.this.appendEvent("handleNewLeader", () -> {
                log.debug("handleNewLeader " + leader);
                MetadataNode.DirectoryNode dir = MetadataNodeManager.this.data.root.mkdirs("metadataQuorum");
                dir.create("leader").setContents(leader.toString());
            }, null);
        }

        public void beginShutdown() {
            log.debug("Metadata log listener sent beginShutdown");
        }
    }

    public static class Data {
        private final MetadataNode.DirectoryNode root = new MetadataNode.DirectoryNode();
        private String workingDirectory = "/";

        public MetadataNode.DirectoryNode root() {
            return this.root;
        }

        public String workingDirectory() {
            return this.workingDirectory;
        }

        public void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }
    }
}

