/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.shell.CommandUtils;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.GlobVisitor;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.MetadataNodeManager;
import org.jline.reader.Candidate;

public final class CdCommandHandler
implements Commands.Handler {
    public static final Commands.Type TYPE = new CdCommandType();
    private final Optional<String> target;

    public CdCommandHandler(Optional<String> target) {
        this.target = target;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, final PrintWriter writer, MetadataNodeManager manager) throws Exception {
        final String effectiveTarget = this.target.orElse("/");
        manager.visit(new Consumer<MetadataNodeManager.Data>(){

            @Override
            public void accept(MetadataNodeManager.Data data) {
                new GlobVisitor(effectiveTarget, entryOption -> {
                    if (entryOption.isPresent()) {
                        if (!(((GlobVisitor.MetadataNodeInfo)entryOption.get()).node() instanceof MetadataNode.DirectoryNode)) {
                            writer.println("cd: " + effectiveTarget + ": not a directory.");
                        } else {
                            data.setWorkingDirectory(((GlobVisitor.MetadataNodeInfo)entryOption.get()).absolutePath());
                        }
                    } else {
                        writer.println("cd: " + effectiveTarget + ": no such directory.");
                    }
                }).accept(data);
            }
        });
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CdCommandHandler)) {
            return false;
        }
        CdCommandHandler o = (CdCommandHandler)other;
        return o.target.equals(this.target);
    }

    public static class CdCommandType
    implements Commands.Type {
        private CdCommandType() {
        }

        @Override
        public String name() {
            return "cd";
        }

        @Override
        public String description() {
            return "Set the current working directory.";
        }

        @Override
        public boolean shellOnly() {
            return true;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"target"}).nargs("?").help("The directory to change to.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new CdCommandHandler(Optional.ofNullable(namespace.getString("target")));
        }

        @Override
        public void completeNext(MetadataNodeManager nodeManager, List<String> nextWords, List<Candidate> candidates) throws Exception {
            if (nextWords.size() == 1) {
                CommandUtils.completePath(nodeManager, nextWords.get(0), candidates);
            }
        }
    }
}

