/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metadata.ClientQuotaRecord;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FenceBrokerRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.PartitionRecordJsonConverter;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metadata.UnfenceBrokerRecord;
import org.apache.kafka.common.metadata.UnregisterBrokerRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.shell.MetadataNodeManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MetadataNodeManagerTest {
    private MetadataNodeManager metadataNodeManager;

    @BeforeEach
    public void setup() throws Exception {
        this.metadataNodeManager = new MetadataNodeManager();
        this.metadataNodeManager.setup();
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.metadataNodeManager.close();
    }

    @Test
    public void testRegisterBrokerRecordAndUnregisterBrokerRecord() {
        RegisterBrokerRecord record = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(2L);
        this.metadataNodeManager.handleMessage((ApiMessage)record);
        Assertions.assertEquals((Object)record.toString(), (Object)this.metadataNodeManager.getData().root().directory(new String[]{"brokers", "1"}).file(new String[]{"registration"}).contents());
        Assertions.assertEquals((Object)"true", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"brokers", "1"}).file(new String[]{"isFenced"}).contents());
        UnregisterBrokerRecord unregisterBrokerRecord = new UnregisterBrokerRecord().setBrokerId(1);
        this.metadataNodeManager.handleMessage((ApiMessage)unregisterBrokerRecord);
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().directory(new String[]{"brokers"}).children().containsKey("1"));
    }

    @Test
    public void testTopicRecordAndRemoveTopicRecord() {
        TopicRecord topicRecord = new TopicRecord().setName("topicName").setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ"));
        this.metadataNodeManager.handleMessage((ApiMessage)topicRecord);
        Assertions.assertEquals((Object)"topicName", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topics", "topicName"}).file(new String[]{"name"}).contents());
        Assertions.assertEquals((Object)"GcaQDl2UTsCNs1p9s37XkQ", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topics", "topicName"}).file(new String[]{"id"}).contents());
        Assertions.assertEquals((Object)"topicName", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topicIds", "GcaQDl2UTsCNs1p9s37XkQ"}).file(new String[]{"name"}).contents());
        Assertions.assertEquals((Object)"GcaQDl2UTsCNs1p9s37XkQ", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topicIds", "GcaQDl2UTsCNs1p9s37XkQ"}).file(new String[]{"id"}).contents());
        RemoveTopicRecord removeTopicRecord = new RemoveTopicRecord().setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ"));
        this.metadataNodeManager.handleMessage((ApiMessage)removeTopicRecord);
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().directory(new String[]{"topicIds"}).children().containsKey("GcaQDl2UTsCNs1p9s37XkQ"));
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().directory(new String[]{"topics"}).children().containsKey("topicName"));
    }

    @Test
    public void testPartitionRecord() {
        PartitionRecord record = new PartitionRecord().setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ")).setPartitionId(0).setLeaderEpoch(1).setReplicas(Arrays.asList(1, 2, 3)).setIsr(Arrays.asList(1, 2, 3));
        this.metadataNodeManager.handleMessage((ApiMessage)record);
        Assertions.assertEquals((Object)PartitionRecordJsonConverter.write((PartitionRecord)record, (short)0).toPrettyString(), (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topicIds", "GcaQDl2UTsCNs1p9s37XkQ", "0"}).file(new String[]{"data"}).contents());
    }

    @Test
    public void testValidConfigRecord() {
        this.checkValidConfigRecord(ConfigResource.Type.BROKER.id(), "broker");
        this.checkValidConfigRecord(ConfigResource.Type.TOPIC.id(), "topic");
    }

    private void checkValidConfigRecord(byte resourceType, String typeString) {
        ConfigRecord configRecord = new ConfigRecord().setResourceType(resourceType).setResourceName("0").setName("name").setValue("kraft");
        this.metadataNodeManager.handleMessage((ApiMessage)configRecord);
        Assertions.assertEquals((Object)"kraft", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"configs", typeString, "0"}).file(new String[]{"name"}).contents());
        configRecord.setValue(null);
        this.metadataNodeManager.handleMessage((ApiMessage)configRecord);
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().directory(new String[]{"configs", typeString, "0"}).children().containsKey("name"));
    }

    @Test
    public void testInvalidConfigRecord() {
        this.checkInvalidConfigRecord(ConfigResource.Type.BROKER_LOGGER.id());
        this.checkInvalidConfigRecord(ConfigResource.Type.UNKNOWN.id());
    }

    private void checkInvalidConfigRecord(byte resourceType) {
        ConfigRecord configRecord = new ConfigRecord().setResourceType(resourceType).setResourceName("0").setName("name").setValue("kraft");
        this.metadataNodeManager.handleMessage((ApiMessage)configRecord);
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().children().containsKey("configs"));
    }

    @Test
    public void testPartitionChangeRecord() {
        PartitionRecord oldPartitionRecord = new PartitionRecord().setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ")).setPartitionId(0).setPartitionEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2));
        PartitionChangeRecord partitionChangeRecord = new PartitionChangeRecord().setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ")).setPartitionId(0).setLeader(-2).setReplicas(Arrays.asList(0, 1, 2));
        PartitionRecord newPartitionRecord = new PartitionRecord().setTopicId(Uuid.fromString((String)"GcaQDl2UTsCNs1p9s37XkQ")).setPartitionId(0).setPartitionEpoch(1).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 2)).setReplicas(Arrays.asList(0, 1, 2));
        this.checkPartitionChangeRecord(oldPartitionRecord, partitionChangeRecord, newPartitionRecord);
        this.checkPartitionChangeRecord(oldPartitionRecord, partitionChangeRecord.duplicate().setIsr(Arrays.asList(0, 2)), newPartitionRecord.duplicate().setIsr(Arrays.asList(0, 2)));
        this.checkPartitionChangeRecord(oldPartitionRecord, partitionChangeRecord.duplicate().setLeader(1), newPartitionRecord.duplicate().setLeader(1).setLeaderEpoch(1));
    }

    private void checkPartitionChangeRecord(PartitionRecord oldPartitionRecord, PartitionChangeRecord partitionChangeRecord, PartitionRecord newPartitionRecord) {
        this.metadataNodeManager.handleMessage((ApiMessage)oldPartitionRecord);
        this.metadataNodeManager.handleMessage((ApiMessage)partitionChangeRecord);
        Assertions.assertEquals((Object)PartitionRecordJsonConverter.write((PartitionRecord)newPartitionRecord, (short)0).toPrettyString(), (Object)this.metadataNodeManager.getData().root().directory(new String[]{"topicIds", oldPartitionRecord.topicId().toString(), oldPartitionRecord.partitionId() + ""}).file(new String[]{"data"}).contents());
    }

    @Test
    public void testUnfenceBrokerRecordAndFenceBrokerRecord() {
        RegisterBrokerRecord record = new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(2L);
        this.metadataNodeManager.handleMessage((ApiMessage)record);
        Assertions.assertEquals((Object)"true", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"brokers", "1"}).file(new String[]{"isFenced"}).contents());
        UnfenceBrokerRecord unfenceBrokerRecord = new UnfenceBrokerRecord().setId(1).setEpoch(2L);
        this.metadataNodeManager.handleMessage((ApiMessage)unfenceBrokerRecord);
        Assertions.assertEquals((Object)"false", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"brokers", "1"}).file(new String[]{"isFenced"}).contents());
        FenceBrokerRecord fenceBrokerRecord = new FenceBrokerRecord().setId(1).setEpoch(2L);
        this.metadataNodeManager.handleMessage((ApiMessage)fenceBrokerRecord);
        Assertions.assertEquals((Object)"true", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"brokers", "1"}).file(new String[]{"isFenced"}).contents());
    }

    @Test
    public void testClientQuotaRecord() {
        ClientQuotaRecord record = new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName("kraft"), new ClientQuotaRecord.EntityData().setEntityType("client").setEntityName("kstream"))).setKey("producer_byte_rate").setValue(1000.0);
        this.metadataNodeManager.handleMessage((ApiMessage)record);
        Assertions.assertEquals((Object)"1000.0", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"client-quotas", "client", "kstream", "user", "kraft"}).file(new String[]{"producer_byte_rate"}).contents());
        this.metadataNodeManager.handleMessage((ApiMessage)record.setRemove(true));
        Assertions.assertFalse((boolean)this.metadataNodeManager.getData().root().directory(new String[]{"client-quotas", "client", "kstream", "user", "kraft"}).children().containsKey("producer_byte_rate"));
        record = new ClientQuotaRecord().setEntity(Arrays.asList(new ClientQuotaRecord.EntityData().setEntityType("user").setEntityName(null))).setKey("producer_byte_rate").setValue(2000.0);
        this.metadataNodeManager.handleMessage((ApiMessage)record);
        Assertions.assertEquals((Object)"2000.0", (Object)this.metadataNodeManager.getData().root().directory(new String[]{"client-quotas", "user", "<default>"}).file(new String[]{"producer_byte_rate"}).contents());
    }
}

