/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.shell.CommandUtils;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.MetadataNodeManager;
import org.jline.reader.Candidate;

public final class ManCommandHandler
implements Commands.Handler {
    private final String cmd;
    public static final Commands.Type TYPE = new ManCommandType();

    public ManCommandHandler(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataNodeManager manager) {
        Commands.Type type = (Commands.Type)Commands.TYPES.get(this.cmd);
        if (type == null) {
            writer.println("man: unknown command " + this.cmd + ". Type help to get a list of commands.");
        } else {
            ArgumentParser parser = ArgumentParsers.newArgumentParser((String)type.name(), (boolean)false);
            type.addArguments(parser);
            writer.printf("%s: %s%n%n", this.cmd, type.description());
            parser.printHelp(writer);
        }
    }

    public int hashCode() {
        return this.cmd.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ManCommandHandler)) {
            return false;
        }
        ManCommandHandler o = (ManCommandHandler)other;
        return o.cmd.equals(this.cmd);
    }

    public static class ManCommandType
    implements Commands.Type {
        private ManCommandType() {
        }

        @Override
        public String name() {
            return "man";
        }

        @Override
        public String description() {
            return "Show the help text for a specific command.";
        }

        @Override
        public boolean shellOnly() {
            return true;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"cmd"}).nargs(1).help("The command to get help text for.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new ManCommandHandler((String)namespace.getList("cmd").get(0));
        }

        @Override
        public void completeNext(MetadataNodeManager nodeManager, List<String> nextWords, List<Candidate> candidates) throws Exception {
            if (nextWords.size() == 1) {
                CommandUtils.completeCommand(nextWords.get(0), candidates);
            }
        }
    }
}

