/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.shell.GlobVisitor;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.MetadataNodeManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class GlobVisitorTest {
    private static final MetadataNodeManager.Data DATA = new MetadataNodeManager.Data();

    @Test
    public void testStarGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("*", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "a"}, DATA.root().directory(new String[]{"foo"}).child("a")), new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "beta"}, DATA.root().directory(new String[]{"foo"}).child("beta")))), (Object)consumer.infos);
    }

    @Test
    public void testDotDot() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("..", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[0], (MetadataNode)DATA.root()))), (Object)consumer.infos);
    }

    @Test
    public void testDoubleDotDot() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../..", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[0], (MetadataNode)DATA.root()))), (Object)consumer.infos);
    }

    @Test
    public void testZGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../z*", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"zeta"}, DATA.root().child("zeta")), new GlobVisitor.MetadataNodeInfo(new String[]{"zzz"}, DATA.root().child("zzz")))), (Object)consumer.infos);
    }

    @Test
    public void testBetaOrThetaGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("../*/{beta,theta}", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"alpha", "beta"}, DATA.root().directory(new String[]{"alpha"}).child("beta")), new GlobVisitor.MetadataNodeInfo(new String[]{"alpha", "theta"}, DATA.root().directory(new String[]{"alpha"}).child("theta")), new GlobVisitor.MetadataNodeInfo(new String[]{"foo", "beta"}, DATA.root().directory(new String[]{"foo"}).child("beta")))), (Object)consumer.infos);
    }

    @Test
    public void testNotFoundGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("epsilon", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.empty(), (Object)consumer.infos);
    }

    @Test
    public void testAbsoluteGlob() {
        InfoConsumer consumer = new InfoConsumer();
        GlobVisitor visitor = new GlobVisitor("/a?pha", (Consumer)consumer);
        visitor.accept(DATA);
        Assertions.assertEquals(Optional.of(Arrays.asList(new GlobVisitor.MetadataNodeInfo(new String[]{"alpha"}, (MetadataNode)DATA.root().directory(new String[]{"alpha"})))), (Object)consumer.infos);
    }

    static {
        DATA.root().mkdirs(new String[]{"alpha", "beta", "gamma"});
        DATA.root().mkdirs(new String[]{"alpha", "theta"});
        DATA.root().mkdirs(new String[]{"foo", "a"});
        DATA.root().mkdirs(new String[]{"foo", "beta"});
        DATA.root().mkdirs(new String[]{"zeta"}).create("c");
        DATA.root().mkdirs(new String[]{"zeta"});
        DATA.root().create("zzz");
        DATA.setWorkingDirectory("foo");
    }

    static class InfoConsumer
    implements Consumer<Optional<GlobVisitor.MetadataNodeInfo>> {
        private Optional<List<GlobVisitor.MetadataNodeInfo>> infos = null;

        InfoConsumer() {
        }

        @Override
        public void accept(Optional<GlobVisitor.MetadataNodeInfo> info) {
            if (this.infos == null) {
                if (info.isPresent()) {
                    this.infos = Optional.of(new ArrayList());
                    this.infos.get().add(info.get());
                } else {
                    this.infos = Optional.empty();
                }
            } else if (info.isPresent()) {
                this.infos.get().add(info.get());
            } else {
                throw new RuntimeException("Saw non-empty info after seeing empty info");
            }
        }
    }
}

