/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.shell.CatCommandHandler;
import org.apache.kafka.shell.CdCommandHandler;
import org.apache.kafka.shell.Commands;
import org.apache.kafka.shell.ErroneousCommandHandler;
import org.apache.kafka.shell.ExitCommandHandler;
import org.apache.kafka.shell.HelpCommandHandler;
import org.apache.kafka.shell.HistoryCommandHandler;
import org.apache.kafka.shell.LsCommandHandler;
import org.apache.kafka.shell.NoOpCommandHandler;
import org.apache.kafka.shell.PwdCommandHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class CommandTest {
    @Test
    public void testParseCommands() {
        Assertions.assertEquals((Object)new CatCommandHandler(Arrays.asList("foo")), (Object)new Commands(true).parseCommand(Arrays.asList("cat", "foo")));
        Assertions.assertEquals((Object)new CdCommandHandler(Optional.empty()), (Object)new Commands(true).parseCommand(Arrays.asList("cd")));
        Assertions.assertEquals((Object)new CdCommandHandler(Optional.of("foo")), (Object)new Commands(true).parseCommand(Arrays.asList("cd", "foo")));
        Assertions.assertEquals((Object)new ExitCommandHandler(), (Object)new Commands(true).parseCommand(Arrays.asList("exit")));
        Assertions.assertEquals((Object)new HelpCommandHandler(), (Object)new Commands(true).parseCommand(Arrays.asList("help")));
        Assertions.assertEquals((Object)new HistoryCommandHandler(3), (Object)new Commands(true).parseCommand(Arrays.asList("history", "3")));
        Assertions.assertEquals((Object)new HistoryCommandHandler(Integer.MAX_VALUE), (Object)new Commands(true).parseCommand(Arrays.asList("history")));
        Assertions.assertEquals((Object)new LsCommandHandler(Collections.emptyList()), (Object)new Commands(true).parseCommand(Arrays.asList("ls")));
        Assertions.assertEquals((Object)new LsCommandHandler(Arrays.asList("abc", "123")), (Object)new Commands(true).parseCommand(Arrays.asList("ls", "abc", "123")));
        Assertions.assertEquals((Object)new PwdCommandHandler(), (Object)new Commands(true).parseCommand(Arrays.asList("pwd")));
    }

    @Test
    public void testParseInvalidCommand() {
        Assertions.assertEquals((Object)new ErroneousCommandHandler("invalid choice: 'blah' (choose from 'cat', 'cd', 'exit', 'find', 'help', 'history', 'ls', 'man', 'pwd')"), (Object)new Commands(true).parseCommand(Arrays.asList("blah")));
    }

    @Test
    public void testEmptyCommandLine() {
        Assertions.assertEquals((Object)new NoOpCommandHandler(), (Object)new Commands(true).parseCommand(Arrays.asList("")));
        Assertions.assertEquals((Object)new NoOpCommandHandler(), (Object)new Commands(true).parseCommand(Collections.emptyList()));
    }
}

