/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.OptionalInt;
import org.apache.kafka.shell.command.LsCommandHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class LsCommandHandlerTest {
    @Test
    public void testCalculateColumnSchema() {
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(1, 3), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.empty(), Arrays.asList("abc", "def", "ghi")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(1, 2), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(0), Arrays.asList("abc", "def")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(3, 1).setColumnWidths(new Integer[]{3, 8, 6}), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(80), Arrays.asList("a", "abcdef", "beta")));
        Assertions.assertEquals((Object)new LsCommandHandler.ColumnSchema(2, 3).setColumnWidths(new Integer[]{10, 7}), (Object)LsCommandHandler.calculateColumnSchema((OptionalInt)OptionalInt.of(18), Arrays.asList("alphabet", "beta", "gamma", "theta", "zeta")));
    }

    @Test
    public void testPrintEntries() throws Exception {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                LsCommandHandler.printEntries((PrintWriter)writer, (String)"", (OptionalInt)OptionalInt.of(18), Arrays.asList("alphabet", "beta", "gamma", "theta", "zeta"));
            }
            Assertions.assertEquals((Object)String.join((CharSequence)String.format("%n", new Object[0]), Arrays.asList("alphabet  theta", "beta      zeta", "gamma")), (Object)stream.toString().trim());
        }
    }

    @Test
    public void testPrintTargets() throws Exception {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8));){
                LsCommandHandler.printTargets((PrintWriter)writer, (OptionalInt)OptionalInt.of(18), Arrays.asList("foo", "foobarbaz", "quux"), Arrays.asList(new LsCommandHandler.TargetDirectory("/some/dir", Collections.singletonList("supercalifragalistic")), new LsCommandHandler.TargetDirectory("/some/other/dir", Arrays.asList("capability", "delegation", "elephant", "fungible", "green"))));
            }
            Assertions.assertEquals((Object)String.join((CharSequence)String.format("%n", new Object[0]), Arrays.asList("foo        quux", "foobarbaz  ", "", "/some/dir:", "supercalifragalistic", "", "/some/other/dir:", "capability", "delegation", "elephant", "fungible", "green")), (Object)stream.toString().trim());
        }
    }
}

