/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.shell.MetadataShell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
@Tag(value="integration")
public class MetadataShellIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataShellIntegrationTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testLock(boolean canLock) throws Exception {
        block10: {
            try (IntegrationEnv env = new IntegrationEnv();){
                env.shell = new MetadataShell(null, new File(new File(env.tempDir, "__cluster_metadata-0"), "00000000000122906351-0000000226.checkpoint").getAbsolutePath(), (FaultHandler)env.faultHandler);
                if (canLock) {
                    Assertions.assertEquals(NoSuchFileException.class, ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> env.shell.run(List.of()))).getCause().getClass());
                    break block10;
                }
                FileLock fileLock = new FileLock(new File(env.tempDir, ".lock"));
                try {
                    fileLock.lock();
                    for (int i = 0; i < 2; ++i) {
                        Assertions.assertEquals((Object)("Unable to lock " + env.tempDir.getAbsolutePath() + ". Please ensure that no broker or controller process is using this directory before proceeding."), (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> env.shell.run(List.of()))).getMessage());
                    }
                }
                finally {
                    fileLock.destroy();
                }
            }
        }
    }

    @Test
    public void testParentParent() {
        File root = File.listRoots()[0];
        Assertions.assertEquals((Object)root, (Object)MetadataShell.parentParent((File)new File(new File(root, "a"), "b")));
    }

    @Test
    public void testParentParentOfRoot() {
        File root = File.listRoots()[0];
        Assertions.assertEquals((Object)root, (Object)MetadataShell.parentParent((File)root));
    }

    static class IntegrationEnv
    implements AutoCloseable {
        File tempDir = Files.createTempDirectory("MetadataShellIntegrationTest", new FileAttribute[0]).toFile();
        MetadataShell shell = null;
        final MockFaultHandler faultHandler = new MockFaultHandler("testFailToGetLockOnSnapshotFile");

        IntegrationEnv() throws IOException {
        }

        @Override
        public void close() {
            if (this.shell != null) {
                try {
                    this.shell.close();
                }
                catch (Throwable e) {
                    LOG.error("Error closing shell", e);
                }
                finally {
                    this.shell = null;
                }
            }
            if (this.tempDir != null) {
                try {
                    Utils.delete((File)this.tempDir);
                }
                catch (Throwable e) {
                    LOG.error("Error deleting tempDir", e);
                }
                finally {
                    this.tempDir = null;
                }
            }
            this.faultHandler.maybeRethrowFirstException();
        }
    }
}

