/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.shell.MetadataNode;
import org.apache.kafka.shell.NotDirectoryException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class MetadataNodeTest {
    @Test
    public void testMkdirs() {
        MetadataNode.DirectoryNode root = new MetadataNode.DirectoryNode();
        MetadataNode.DirectoryNode defNode = root.mkdirs(new String[]{"abc", "def"});
        MetadataNode.DirectoryNode defNode2 = root.mkdirs(new String[]{"abc", "def"});
        Assertions.assertTrue((defNode == defNode2 ? 1 : 0) != 0);
        MetadataNode.DirectoryNode defNode3 = root.directory(new String[]{"abc", "def"});
        Assertions.assertTrue((defNode == defNode3 ? 1 : 0) != 0);
        root.mkdirs(new String[]{"ghi"});
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("abc", "ghi")), root.children().keySet());
        Assertions.assertEquals(Collections.singleton("def"), root.mkdirs(new String[]{"abc"}).children().keySet());
        Assertions.assertEquals(Collections.emptySet(), defNode.children().keySet());
    }

    @Test
    public void testRmrf() {
        MetadataNode.DirectoryNode root = new MetadataNode.DirectoryNode();
        MetadataNode.DirectoryNode foo = root.mkdirs(new String[]{"foo"});
        foo.mkdirs(new String[]{"a"});
        foo.mkdirs(new String[]{"b"});
        root.mkdirs(new String[]{"baz"});
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo", "baz")), root.children().keySet());
        root.rmrf(new String[]{"foo", "a"});
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("b")), foo.children().keySet());
        root.rmrf(new String[]{"foo"});
        Assertions.assertEquals(new HashSet<String>(Collections.singleton("baz")), root.children().keySet());
    }

    @Test
    public void testCreateFiles() {
        MetadataNode.DirectoryNode root = new MetadataNode.DirectoryNode();
        MetadataNode.DirectoryNode abcdNode = root.mkdirs(new String[]{"abcd"});
        MetadataNode.FileNode quuxNodde = abcdNode.create("quux");
        quuxNodde.setContents("quux contents");
        Assertions.assertEquals((Object)"quux contents", (Object)quuxNodde.contents());
        Assertions.assertThrows(NotDirectoryException.class, () -> root.mkdirs(new String[]{"abcd", "quux"}));
    }
}

