/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.shell.GlobComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
public class GlobComponentTest {
    private void verifyIsLiteral(GlobComponent globComponent, String component) {
        Assertions.assertTrue((boolean)globComponent.literal());
        Assertions.assertEquals((Object)component, (Object)globComponent.component());
        Assertions.assertTrue((boolean)globComponent.matches(component));
        Assertions.assertFalse((boolean)globComponent.matches(component + "foo"));
    }

    @Test
    public void testLiteralComponent() {
        this.verifyIsLiteral(new GlobComponent("abc"), "abc");
        this.verifyIsLiteral(new GlobComponent(""), "");
        this.verifyIsLiteral(new GlobComponent("foobar_123"), "foobar_123");
        this.verifyIsLiteral(new GlobComponent("$blah+"), "$blah+");
    }

    @Test
    public void testToRegularExpression() {
        Assertions.assertEquals(null, (Object)GlobComponent.toRegularExpression((String)"blah"));
        Assertions.assertEquals(null, (Object)GlobComponent.toRegularExpression((String)""));
        Assertions.assertEquals(null, (Object)GlobComponent.toRegularExpression((String)"does not need a regex, actually"));
        Assertions.assertEquals((Object)"^\\$blah.*$", (Object)GlobComponent.toRegularExpression((String)"$blah*"));
        Assertions.assertEquals((Object)"^.*$", (Object)GlobComponent.toRegularExpression((String)"*"));
        Assertions.assertEquals((Object)"^foo(?:(?:bar)|(?:baz))$", (Object)GlobComponent.toRegularExpression((String)"foo{bar,baz}"));
    }

    @Test
    public void testGlobMatch() {
        GlobComponent star = new GlobComponent("*");
        Assertions.assertFalse((boolean)star.literal());
        Assertions.assertTrue((boolean)star.matches(""));
        Assertions.assertTrue((boolean)star.matches("anything"));
        GlobComponent question = new GlobComponent("b?b");
        Assertions.assertFalse((boolean)question.literal());
        Assertions.assertFalse((boolean)question.matches(""));
        Assertions.assertTrue((boolean)question.matches("bob"));
        Assertions.assertTrue((boolean)question.matches("bib"));
        Assertions.assertFalse((boolean)question.matches("bic"));
        GlobComponent foobarOrFoobaz = new GlobComponent("foo{bar,baz}");
        Assertions.assertFalse((boolean)foobarOrFoobaz.literal());
        Assertions.assertTrue((boolean)foobarOrFoobaz.matches("foobar"));
        Assertions.assertTrue((boolean)foobarOrFoobaz.matches("foobaz"));
        Assertions.assertFalse((boolean)foobarOrFoobaz.matches("foobah"));
        Assertions.assertFalse((boolean)foobarOrFoobaz.matches("foo"));
        Assertions.assertFalse((boolean)foobarOrFoobaz.matches("baz"));
    }
}

