/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.share.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import java.util.ArrayList;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.coordinator.share.generated.ShareUpdateValue.*;

public class ShareUpdateValueJsonConverter {
    public static ShareUpdateValue read(JsonNode _node, short _version) {
        ShareUpdateValue _object = new ShareUpdateValue();
        JsonNode _snapshotEpochNode = _node.get("snapshotEpoch");
        if (_snapshotEpochNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'snapshotEpoch', which is mandatory in version " + _version);
        } else {
            _object.snapshotEpoch = MessageUtil.jsonNodeToUnsignedShort(_snapshotEpochNode, "ShareUpdateValue");
        }
        JsonNode _leaderEpochNode = _node.get("leaderEpoch");
        if (_leaderEpochNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
        } else {
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "ShareUpdateValue");
        }
        JsonNode _startOffsetNode = _node.get("startOffset");
        if (_startOffsetNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'startOffset', which is mandatory in version " + _version);
        } else {
            _object.startOffset = MessageUtil.jsonNodeToLong(_startOffsetNode, "ShareUpdateValue");
        }
        JsonNode _stateBatchesNode = _node.get("stateBatches");
        if (_stateBatchesNode == null) {
            throw new RuntimeException("ShareUpdateValue: unable to locate field 'stateBatches', which is mandatory in version " + _version);
        } else {
            if (!_stateBatchesNode.isArray()) {
                throw new RuntimeException("ShareUpdateValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<StateBatch> _collection = new ArrayList<StateBatch>(_stateBatchesNode.size());
            _object.stateBatches = _collection;
            for (JsonNode _element : _stateBatchesNode) {
                _collection.add(StateBatchJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(ShareUpdateValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("snapshotEpoch", new IntNode(_object.snapshotEpoch));
        _node.set("leaderEpoch", new IntNode(_object.leaderEpoch));
        _node.set("startOffset", new LongNode(_object.startOffset));
        ArrayNode _stateBatchesArray = new ArrayNode(JsonNodeFactory.instance);
        for (StateBatch _element : _object.stateBatches) {
            _stateBatchesArray.add(StateBatchJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("stateBatches", _stateBatchesArray);
        return _node;
    }
    public static JsonNode write(ShareUpdateValue _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class StateBatchJsonConverter {
        public static StateBatch read(JsonNode _node, short _version) {
            StateBatch _object = new StateBatch();
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            } else {
                _object.firstOffset = MessageUtil.jsonNodeToLong(_firstOffsetNode, "StateBatch");
            }
            JsonNode _lastOffsetNode = _node.get("lastOffset");
            if (_lastOffsetNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'lastOffset', which is mandatory in version " + _version);
            } else {
                _object.lastOffset = MessageUtil.jsonNodeToLong(_lastOffsetNode, "StateBatch");
            }
            JsonNode _deliveryStateNode = _node.get("deliveryState");
            if (_deliveryStateNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'deliveryState', which is mandatory in version " + _version);
            } else {
                _object.deliveryState = MessageUtil.jsonNodeToByte(_deliveryStateNode, "StateBatch");
            }
            JsonNode _deliveryCountNode = _node.get("deliveryCount");
            if (_deliveryCountNode == null) {
                throw new RuntimeException("StateBatch: unable to locate field 'deliveryCount', which is mandatory in version " + _version);
            } else {
                _object.deliveryCount = MessageUtil.jsonNodeToShort(_deliveryCountNode, "StateBatch");
            }
            return _object;
        }
        public static JsonNode write(StateBatch _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("firstOffset", new LongNode(_object.firstOffset));
            _node.set("lastOffset", new LongNode(_object.lastOffset));
            _node.set("deliveryState", new ShortNode(_object.deliveryState));
            _node.set("deliveryCount", new ShortNode(_object.deliveryCount));
            return _node;
        }
        public static JsonNode write(StateBatch _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
