/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.storage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.metadata.storage.ScramParserTest;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=40L)
public class FormatterTest {
    private static final Logger LOG = LoggerFactory.getLogger(FormatterTest.class);
    private static final int DEFAULT_NODE_ID = 1;
    private static final Uuid DEFAULT_CLUSTER_ID = Uuid.fromString((String)"b3dGE68sQQKzfk80C_aLZw");

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3})
    public void testDirectories(int numDirs) throws Exception {
        try (TestEnv testEnv = new TestEnv(numDirs);){
            testEnv.newFormatter().formatter.run();
            MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble.Loader().addLogDirs(testEnv.directories).load();
            Assertions.assertEquals((Object)OptionalInt.of(1), (Object)ensemble.nodeId());
            Assertions.assertEquals(Optional.of(DEFAULT_CLUSTER_ID.toString()), (Object)ensemble.clusterId());
            Assertions.assertEquals(new HashSet<String>(testEnv.directories), ensemble.logDirProps().keySet());
            BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(testEnv.directory(0)).read();
            Assertions.assertEquals((Object)MetadataVersion.latestProduction(), (Object)bootstrapMetadata.metadataVersion());
        }
    }

    @Test
    public void testFormatterFailsOnAlreadyFormatted() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            testEnv.newFormatter().formatter.run();
            Assertions.assertEquals((Object)("Log directory " + testEnv.directory(0) + " is already formatted. Use --ignore-formatted to ignore this directory and format the others."), (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> testEnv.newFormatter().formatter.run())).getMessage());
        }
    }

    @Test
    public void testFormatterFailsOnUnwritableDirectory() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            new File(testEnv.directory(0)).setReadOnly();
            FormatterContext formatter1 = testEnv.newFormatter();
            String expectedPrefix = "Error while writing meta.properties file";
            Assertions.assertEquals((Object)expectedPrefix, (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage().substring(0, expectedPrefix.length()));
        }
    }

    @Test
    public void testIgnoreFormatted() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.run();
            Assertions.assertEquals((Object)("Formatting metadata directory " + testEnv.directory(0) + " with confluent.metadata.version " + String.valueOf(MetadataVersion.latestProduction()) + "."), (Object)formatter1.output().trim());
            FormatterContext formatter2 = testEnv.newFormatter();
            formatter2.formatter.setIgnoreFormatted(true);
            formatter2.formatter.run();
            Assertions.assertEquals((Object)"All of the log directories are already formatted.", (Object)formatter2.output().trim());
        }
    }

    @Test
    public void testOneDirectoryFormattedAndOthersNotFormatted() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            testEnv.newFormatter().formatter.setDirectories(Arrays.asList(testEnv.directory(0))).run();
            Assertions.assertEquals((Object)("Log directory " + testEnv.directory(0) + " is already formatted. Use --ignore-formatted to ignore this directory and format the others."), (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> testEnv.newFormatter().formatter.run())).getMessage());
        }
    }

    @Test
    public void testOneDirectoryFormattedAndOthersNotFormattedWithIgnoreFormatted() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            testEnv.newFormatter().formatter.setDirectories(Arrays.asList(testEnv.directory(0))).run();
            FormatterContext formatter2 = testEnv.newFormatter();
            formatter2.formatter.setIgnoreFormatted(true);
            formatter2.formatter.run();
            Assertions.assertEquals((Object)("Formatting data directory " + testEnv.directory(1) + " with confluent.metadata.version " + String.valueOf(MetadataVersion.latestProduction()) + "."), (Object)formatter2.output().trim());
        }
    }

    @Test
    public void testFormatWithOlderReleaseVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.IBP_3_5_IV0);
            formatter1.formatter.run();
            Assertions.assertEquals((Object)("Formatting metadata directory " + testEnv.directory(0) + " with confluent.metadata.version " + String.valueOf(MetadataVersion.IBP_3_5_IV0) + "."), (Object)formatter1.output().trim());
            BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(testEnv.directory(0)).read();
            Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)bootstrapMetadata.metadataVersion());
            Assertions.assertEquals((int)1, (int)bootstrapMetadata.records().size());
        }
    }

    @Test
    public void testFormatWithUnstableReleaseVersionFailsWithoutEnableUnstable() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.latestTesting());
            Assertions.assertEquals((Object)("confluent.metadata.version " + String.valueOf(MetadataVersion.latestTesting()) + " is not yet stable."), (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    @Test
    public void testFormatWithUnstableReleaseVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.latestTesting());
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.run();
            Assertions.assertEquals((Object)("Formatting metadata directory " + testEnv.directory(0) + " with confluent.metadata.version " + String.valueOf(MetadataVersion.latestTesting()) + "."), (Object)formatter1.output().trim());
            BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(testEnv.directory(0)).read();
            Assertions.assertEquals((Object)MetadataVersion.latestTesting(), (Object)bootstrapMetadata.metadataVersion());
        }
    }

    @Test
    public void testFormattingCreatesLogDirId() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.run();
            MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble.Loader().addLogDirs(testEnv.directories).load();
            MetaProperties logDirProps = (MetaProperties)ensemble.logDirProps().get(testEnv.directory(0));
            Assertions.assertNotNull((Object)logDirProps);
            Assertions.assertTrue((boolean)logDirProps.directoryId().isPresent());
        }
    }

    @Test
    public void testFormatWithScramFailsOnUnsupportedReleaseVersions() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.IBP_3_4_IV0);
            formatter1.formatter.setScramArguments(Arrays.asList("SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\"]", "SCRAM-SHA-512=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\"]"));
            Assertions.assertEquals((Object)"SCRAM is only supported in confluent.metadata.version 3.5-IV2 or later.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    @Test
    public void testFormatWithScram() throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.IBP_3_8_IV0A);
            formatter1.formatter.setScramArguments(Arrays.asList("SCRAM-SHA-256=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\"]", "SCRAM-SHA-512=[name=alice,salt=\"MWx2NHBkbnc0ZndxN25vdGN4bTB5eTFrN3E=\",saltedpassword=\"mT0yyUUxnlJaC99HXgRTSYlbuqa4FSGtJCJfTMvjYCE=\"]"));
            formatter1.formatter.run();
            Assertions.assertEquals((Object)("Formatting metadata directory " + testEnv.directory(0) + " with confluent.metadata.version " + String.valueOf(MetadataVersion.IBP_3_8_IV0A) + "."), (Object)formatter1.output().trim());
            BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(testEnv.directory(0)).read();
            Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0A, (Object)bootstrapMetadata.metadataVersion());
            List scramRecords = bootstrapMetadata.records().stream().filter(r -> r.message() instanceof UserScramCredentialRecord).collect(Collectors.toList());
            ScramFormatter scram256 = new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
            ScramFormatter scram512 = new ScramFormatter(ScramMechanism.SCRAM_SHA_512);
            Assertions.assertEquals(Arrays.asList(new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName("alice").setMechanism(ScramMechanism.SCRAM_SHA_256.type()).setSalt(ScramParserTest.TEST_SALT).setStoredKey(scram256.storedKey(scram256.clientKey(ScramParserTest.TEST_SALTED_PASSWORD))).setServerKey(scram256.serverKey(ScramParserTest.TEST_SALTED_PASSWORD)).setIterations(4096), 0), new ApiMessageAndVersion((ApiMessage)new UserScramCredentialRecord().setName("alice").setMechanism(ScramMechanism.SCRAM_SHA_512.type()).setSalt(ScramParserTest.TEST_SALT).setStoredKey(scram512.storedKey(scram512.clientKey(ScramParserTest.TEST_SALTED_PASSWORD))).setServerKey(scram512.serverKey(ScramParserTest.TEST_SALTED_PASSWORD)).setIterations(4096), 0)), scramRecords);
        }
    }

    @ParameterizedTest
    @ValueSource(shorts={0, 1})
    public void testFeatureFlag(short version) throws Exception {
        try (TestEnv testEnv = new TestEnv(1);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setSupportedFeatures(Feature.TEST_AND_PRODUCTION_FEATURES);
            formatter1.formatter.setFeatureLevel("test.feature.version", Short.valueOf(version));
            formatter1.formatter.run();
            BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(testEnv.directory(0)).read();
            ArrayList<ApiMessageAndVersion> expected = new ArrayList<ApiMessageAndVersion>();
            expected.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("confluent.metadata.version").setFeatureLevel(MetadataVersion.latestProduction().confluentFeatureLevel()), 0));
            expected.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("group.version").setFeatureLevel(Feature.GROUP_VERSION.defaultLevel(MetadataVersion.latestProduction())), 0));
            if (version > 0) {
                expected.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("test.feature.version").setFeatureLevel(version), 0));
            }
            expected.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("transaction.version").setFeatureLevel(TransactionVersion.TV_2.featureLevel()), 0));
            Assertions.assertEquals(expected, (Object)bootstrapMetadata.records());
        }
    }

    @Test
    public void testInvalidFeatureFlag() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setSupportedFeatures(Feature.TEST_AND_PRODUCTION_FEATURES);
            formatter1.formatter.setFeatureLevel("nonexistent.feature", Short.valueOf((short)1));
            Assertions.assertEquals((Object)"Unsupported feature: nonexistent.feature. Supported features are: eligible.leader.replicas.version, group.version, kraft.version, test.feature.version, transaction.version", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialVoters(boolean specifyKRaftVersion) throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            if (specifyKRaftVersion) {
                formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)1));
            }
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.setInitialControllers(DynamicVoters.parse((String)"1@localhost:8020:4znU-ou9Taa06bmEJxsjnw"));
            formatter1.formatter.run();
            Assertions.assertEquals((short)1, (Short)formatter1.formatter.featureLevels.getOrDefault("kraft.version", (short)0));
            Assertions.assertEquals(Arrays.asList(String.format("Formatting data directory %s with %s %s.", testEnv.directory(1), "confluent.metadata.version", MetadataVersion.latestTesting()), String.format("Formatting dynamic metadata voter directory %s with %s %s.", testEnv.directory(0), "confluent.metadata.version", MetadataVersion.latestTesting())), formatter1.outputLines().stream().sorted().collect(Collectors.toList()));
            MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble.Loader().addLogDirs(testEnv.directories).load();
            MetaProperties logDirProps0 = (MetaProperties)ensemble.logDirProps().get(testEnv.directory(0));
            Assertions.assertNotNull((Object)logDirProps0);
            Assertions.assertEquals((Object)Uuid.fromString((String)"4znU-ou9Taa06bmEJxsjnw"), logDirProps0.directoryId().get());
            MetaProperties logDirProps1 = (MetaProperties)ensemble.logDirProps().get(testEnv.directory(1));
            Assertions.assertNotNull((Object)logDirProps1);
            Assertions.assertNotEquals((Object)Uuid.fromString((String)"4znU-ou9Taa06bmEJxsjnw"), logDirProps1.directoryId().get());
        }
    }

    @Test
    public void testFormatWithInitialVotersFailsWithOlderKraftVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)0));
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.setInitialControllers(DynamicVoters.parse((String)"1@localhost:8020:4znU-ou9Taa06bmEJxsjnw"));
            Assertions.assertTrue((boolean)formatter1.formatter.hasDynamicQuorum());
            Assertions.assertEquals((Object)"Cannot set kraft.version to 0 if KIP-853 configuration is present. Try removing the --feature flag for kraft.version.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    @Test
    public void testFormatWithoutInitialVotersFailsWithNewerKraftVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)1));
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            Assertions.assertFalse((boolean)formatter1.formatter.hasDynamicQuorum());
            Assertions.assertEquals((Object)"Cannot set kraft.version to 1 unless KIP-853 configuration is present. Try removing the --feature flag for kraft.version.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    @Test
    public void testFormatWithInitialVotersFailsWithOlderMetadataVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(MetadataVersion.IBP_3_8_IV0A);
            formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)1));
            formatter1.formatter.setInitialControllers(DynamicVoters.parse((String)"1@localhost:8020:4znU-ou9Taa06bmEJxsjnw"));
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            Assertions.assertEquals((Object)"kraft.version could not be set to 1 because it depends on confluent.metadata.version level 122", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> formatter1.formatter.run())).getMessage());
        }
    }

    private static Stream<Arguments> elrTestMetadataVersions() {
        return Stream.of(MetadataVersion.IBP_3_9_IV0A, MetadataVersion.IBP_4_0_IV0A, MetadataVersion.IBP_4_0_IV1A).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"elrTestMetadataVersions"})
    public void testFormatElrEnabledWithMetadataVersions(MetadataVersion metadataVersion) throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setReleaseVersion(metadataVersion);
            formatter1.formatter.setFeatureLevel("eligible.leader.replicas.version", Short.valueOf((short)1));
            formatter1.formatter.setInitialControllers(DynamicVoters.parse((String)"1@localhost:8020:4znU-ou9Taa06bmEJxsjnw"));
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV1A)) {
                Assertions.assertDoesNotThrow(() -> formatter1.formatter.run());
            } else {
                Assertions.assertEquals((Object)"eligible.leader.replicas.version could not be set to 1 because it depends on confluent.metadata.version level 125", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> formatter1.formatter.run())).getMessage());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithNoInitialControllers(boolean specifyKRaftVersion) throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            if (specifyKRaftVersion) {
                formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)1));
            }
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.setNoInitialControllersFlag(true);
            Assertions.assertTrue((boolean)formatter1.formatter.hasDynamicQuorum());
            formatter1.formatter.run();
            Assertions.assertEquals((short)1, (Short)formatter1.formatter.featureLevels.getOrDefault("kraft.version", (short)0));
            Assertions.assertEquals(Arrays.asList(String.format("Formatting data directory %s with %s %s.", testEnv.directory(1), "confluent.metadata.version", MetadataVersion.latestTesting()), String.format("Formatting metadata directory %s with %s %s.", testEnv.directory(0), "confluent.metadata.version", MetadataVersion.latestTesting())), formatter1.outputLines().stream().sorted().collect(Collectors.toList()));
            MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble.Loader().addLogDirs(testEnv.directories).load();
            MetaProperties logDirProps0 = (MetaProperties)ensemble.logDirProps().get(testEnv.directory(0));
            Assertions.assertNotNull((Object)logDirProps0);
            MetaProperties logDirProps1 = (MetaProperties)ensemble.logDirProps().get(testEnv.directory(1));
            Assertions.assertNotNull((Object)logDirProps1);
        }
    }

    @Test
    public void testFormatWithoutNoInitialControllersFailsWithNewerKraftVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)1));
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.setNoInitialControllersFlag(false);
            Assertions.assertFalse((boolean)formatter1.formatter.hasDynamicQuorum());
            Assertions.assertEquals((Object)"Cannot set kraft.version to 1 unless KIP-853 configuration is present. Try removing the --feature flag for kraft.version.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ((Formatter)formatter1.formatter).run())).getMessage());
        }
    }

    @Test
    public void testFormatWithNoInitialControllersFailsWithOlderKraftVersion() throws Exception {
        try (TestEnv testEnv = new TestEnv(2);){
            FormatterContext formatter1 = testEnv.newFormatter();
            formatter1.formatter.setFeatureLevel("kraft.version", Short.valueOf((short)0));
            formatter1.formatter.setUnstableFeatureVersionsEnabled(true);
            formatter1.formatter.setNoInitialControllersFlag(true);
            Assertions.assertTrue((boolean)formatter1.formatter.hasDynamicQuorum());
            Assertions.assertEquals((Object)"Cannot set kraft.version to 0 if KIP-853 configuration is present. Try removing the --feature flag for kraft.version.", (Object)((FormatterException)Assertions.assertThrows(FormatterException.class, () -> ((Formatter)formatter1.formatter).run())).getMessage());
        }
    }

    static class TestEnv
    implements AutoCloseable {
        final List<String> directories;

        TestEnv(int numDirs) {
            this.directories = new ArrayList<String>(numDirs);
            for (int i = 0; i < numDirs; ++i) {
                this.directories.add(TestUtils.tempDirectory().getAbsolutePath());
            }
        }

        FormatterContext newFormatter() {
            Formatter formatter = new Formatter().setNodeId(1).setClusterId(DEFAULT_CLUSTER_ID.toString());
            this.directories.forEach(d -> formatter.addDirectory(d));
            formatter.setMetadataLogDirectory(this.directories.get(0));
            return new FormatterContext(formatter);
        }

        String directory(int i) {
            return this.directories.get(i);
        }

        void deleteDirectory(int i) throws IOException {
            Utils.delete((File)new File(this.directories.get(i)));
        }

        @Override
        public void close() throws Exception {
            for (int i = 0; i < this.directories.size(); ++i) {
                try {
                    this.deleteDirectory(i);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Error deleting directory " + this.directories.get(i), (Throwable)e);
                }
            }
        }
    }

    static class FormatterContext {
        final Formatter formatter;
        final ByteArrayOutputStream stream;

        FormatterContext(Formatter formatter) {
            this.formatter = formatter;
            this.stream = new ByteArrayOutputStream();
            this.formatter.setPrintStream(new PrintStream(this.stream));
            this.formatter.setControllerListenerName("CONTROLLER");
        }

        String output() {
            return this.stream.toString();
        }

        List<String> outputLines() {
            return Arrays.asList(this.stream.toString().trim().split("\\r*\\n"));
        }
    }
}

