/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.ingester.Ingester;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IngesterTest {
    @Test
    public void testOffsetsToStringWithMap() {
        Assertions.assertEquals((Object)"[]", (Object)Ingester.offsetsToString(Collections.emptyMap()));
    }

    @Test
    public void testOffsetsToStringWithSingletonMap() {
        Assertions.assertEquals((Object)"[foo-0: 123]", (Object)Ingester.offsetsToString(Map.of(new TopicPartition("foo", 0), 123L)));
    }

    @Test
    public void testOffsetsToStringWithMultiPartitionMap() {
        Assertions.assertEquals((Object)"[foo-0: 123, foo-1: 456, foo-2: 45]", (Object)Ingester.offsetsToString(Map.of(new TopicPartition("foo", 0), 123L, new TopicPartition("foo", 1), 456L, new TopicPartition("foo", 2), 45L)));
    }

    @Test
    public void testOffsetsToStringWithMultiTopicMap() {
        Assertions.assertEquals((Object)"[bar-0: 67, foo-0: 123, foo-1: 456, foo-2: 45]", (Object)Ingester.offsetsToString(Map.of(new TopicPartition("foo", 0), 123L, new TopicPartition("foo", 1), 456L, new TopicPartition("foo", 2), 45L, new TopicPartition("bar", 0), 67L)));
    }

    @Test
    public void testFindUniqueTopicNamesWithEmptyMap() {
        Assertions.assertEquals(Collections.emptySet(), (Object)Ingester.findUniqueTopicNames(Collections.emptyList()));
    }

    @Test
    public void testFindUniqueTopicNamesWithSingletonMap() {
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo")), (Object)Ingester.findUniqueTopicNames(Arrays.asList(new TopicPartition("foo", 0))));
    }

    @Test
    public void testFindUniqueTopicNamesWithMultiPartitionMap() {
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo")), (Object)Ingester.findUniqueTopicNames(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("foo", 2))));
    }

    @Test
    public void testFindUniqueTopicNamesWithMultiTopicMap() {
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar")), (Object)Ingester.findUniqueTopicNames(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("foo", 2), new TopicPartition("bar", 0))));
    }
}

