/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.ingester;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.metadata.ingester.IngesterRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IngesterRecordTest {
    static final IngesterRecord EXAMPLE1 = new IngesterRecord(10100L, new TopicPartition("foo", 0), 0L, "key1", "value1");
    static final IngesterRecord EXAMPLE2 = new IngesterRecord(10100L, new TopicPartition("foo", 1), 120L, "key2", "value2");

    @Test
    public void testTimeMs() {
        Assertions.assertEquals((long)10100L, (long)EXAMPLE1.timeMs());
    }

    @Test
    public void testTopicPartition() {
        Assertions.assertEquals((Object)new TopicPartition("foo", 0), (Object)EXAMPLE1.topicPartition());
    }

    @Test
    public void testOffset() {
        Assertions.assertEquals((long)120L, (long)EXAMPLE2.offset());
    }

    @Test
    public void testKey() {
        Assertions.assertEquals((Object)"key1", (Object)EXAMPLE1.key());
    }

    @Test
    public void testValue() {
        Assertions.assertEquals((Object)"value1", (Object)EXAMPLE1.value());
    }

    @Test
    public void testSelfEquals() {
        Assertions.assertEquals((Object)EXAMPLE1, (Object)EXAMPLE1);
    }

    @Test
    public void testSelfEquals2() {
        Assertions.assertEquals((Object)EXAMPLE1, (Object)EXAMPLE1);
    }

    @Test
    public void testNotEquals() {
        Assertions.assertNotEquals((Object)EXAMPLE1, (Object)EXAMPLE2);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"IngesterRecord(timeMs=10100, topicPartition=foo-1, offset=120, key='key2', value='value2')", (Object)EXAMPLE2.toString());
    }

    @Test
    public void testToConsumerRecordRoundTripExample1() {
        Assertions.assertEquals((Object)EXAMPLE1, (Object)IngesterRecord.fromConsumerRecord((ConsumerRecord)EXAMPLE1.toConsumerRecord()));
    }

    @Test
    public void testToConsumerRecordRoundTripExample2() {
        Assertions.assertEquals((Object)EXAMPLE2, (Object)IngesterRecord.fromConsumerRecord((ConsumerRecord)EXAMPLE2.toConsumerRecord()));
    }
}

