/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.config;

import java.util.Collections;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.config.ConfigMonitorKeyAndDefinition;
import org.apache.kafka.metadata.config.ConfigRegistryTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=120L)
public final class ConfigMonitorKeyAndDefinitionTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMonitorKeyAndDefinitionTest.class);

    @Test
    public void testFromSchema() {
        ConfigMonitorKeyAndDefinition.fromSchema((ConfigResource.Type)ConfigResource.Type.BROKER, (String)"num.foobars", (KafkaConfigSchema)ConfigRegistryTestConstants.SCHEMA, (ConfigDef.Type)ConfigDef.Type.SHORT);
    }

    @Test
    public void testFromSchemaFails() {
        Assertions.assertEquals((Object)"Unexpected value type for resource type BROKER, config keyName num.foobars; needed BOOLEAN, got SHORT", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfigMonitorKeyAndDefinition.fromSchema((ConfigResource.Type)ConfigResource.Type.BROKER, (String)"num.foobars", (KafkaConfigSchema)ConfigRegistryTestConstants.SCHEMA, (ConfigDef.Type)ConfigDef.Type.BOOLEAN))).getMessage());
    }

    @Test
    public void testLoadBrokerNumFoobarsStaticValue() {
        Assertions.assertEquals((Object)3, (Object)ConfigRegistryTestConstants.BROKER_NUM_FOOBARS.loadStaticValue(LOG, ConfigRegistryTestConstants.STATIC_CONFIG_MAP));
    }

    @Test
    public void testLoadTopicBaazEnabledStaticValue() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ConfigRegistryTestConstants.TOPIC_BAAZ_ENABLED.loadStaticValue(LOG, ConfigRegistryTestConstants.STATIC_CONFIG_MAP));
    }

    @Test
    public void testLoadTopicBaazEnabledStaticValueEmptyConfigMap() {
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ConfigRegistryTestConstants.TOPIC_BAAZ_ENABLED.loadStaticValue(LOG, Collections.emptyMap()));
    }

    @Test
    public void testLoadTopicNumFoobarsStaticValue() {
        Assertions.assertEquals((Object)3, (Object)ConfigRegistryTestConstants.TOPIC_NUM_FOOBARS.loadStaticValue(LOG, ConfigRegistryTestConstants.STATIC_CONFIG_MAP));
    }
}

