/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.io.File;
import java.util.List;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.NoOpRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class BootstrapDirectoryTest {
    static final List<ApiMessageAndVersion> SAMPLE_RECORDS1 = List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)7), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0), new ApiMessageAndVersion((ApiMessage)new NoOpRecord(), 0));

    @Test
    public void testReadFromEmptyConfiguration() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            Assertions.assertEquals((Object)BootstrapMetadata.fromVersion((MetadataVersion)MetadataVersion.latestProduction(), (String)"the default bootstrap"), (Object)new BootstrapDirectory(testDirectory.path()).read());
        }
    }

    @Test
    public void testMissingDirectory() {
        Assertions.assertEquals((Object)"No such directory as ./non/existent/directory", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new BootstrapDirectory("./non/existent/directory").read())).getMessage());
    }

    @Test
    public void testReadFromConfigurationFile() throws Exception {
        try (BootstrapTestDirectory testDirectory = new BootstrapTestDirectory().createDirectory();){
            BootstrapDirectory directory = new BootstrapDirectory(testDirectory.path());
            BootstrapMetadata metadata = BootstrapMetadata.fromRecords(SAMPLE_RECORDS1, (String)("the binary bootstrap metadata file: " + testDirectory.binaryBootstrapPath()));
            directory.writeBinaryFile(metadata);
            Assertions.assertEquals((Object)metadata, (Object)directory.read());
        }
    }

    static class BootstrapTestDirectory
    implements AutoCloseable {
        File directory = null;

        BootstrapTestDirectory() {
        }

        synchronized BootstrapTestDirectory createDirectory() {
            this.directory = TestUtils.tempDirectory((String)"BootstrapTestDirectory");
            return this;
        }

        synchronized String path() {
            return this.directory.getAbsolutePath();
        }

        synchronized String binaryBootstrapPath() {
            return new File(this.directory, "bootstrap.checkpoint").getAbsolutePath();
        }

        @Override
        public synchronized void close() throws Exception {
            if (this.directory != null) {
                Utils.delete((File)this.directory);
            }
            this.directory = null;
        }
    }
}

