/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;

public class StandardAuthorizerTestConstants {
    public static final List<StandardAcl> WILDCARD_ACLS_1 = Arrays.asList(new StandardAcl(ResourceType.TOPIC, "*", PatternType.LITERAL, "User:*", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "*", PatternType.LITERAL, "User:*", "127.0.0.10", AclOperation.READ, AclPermissionType.DENY));
    public static final List<StandardAcl> WILDCARD_ACLS = Arrays.asList(new StandardAcl(ResourceType.TOPIC, "*", PatternType.LITERAL, "User:*", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.TOPIC, "*", PatternType.LITERAL, "User:bar", "*", AclOperation.READ, AclPermissionType.DENY));
    public static final List<StandardAcl> LITERAL_ACLS = Arrays.asList(new StandardAcl(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL, "User:bob", "*", AclOperation.ALTER, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.LITERAL, "User:alice", "*", AclOperation.READ, AclPermissionType.DENY), new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.LITERAL, "User:bar", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "mygroup2", PatternType.LITERAL, "User:bar", "*", AclOperation.WRITE, AclPermissionType.DENY));
    public static final List<StandardAcl> PREFIX_ACLS = Arrays.asList(new StandardAcl(ResourceType.TOPIC, "foo_", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.PREFIXED, "User:foo", "*", AclOperation.READ, AclPermissionType.DENY), new StandardAcl(ResourceType.GROUP, "foo", PatternType.PREFIXED, "User:foo", "*", AclOperation.READ, AclPermissionType.DENY), new StandardAcl(ResourceType.GROUP, "f", PatternType.PREFIXED, "User:bar", "*", AclOperation.READ, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "f", PatternType.PREFIXED, "User:bar", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "f", PatternType.PREFIXED, "User:foo", "*", AclOperation.WRITE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "four", PatternType.PREFIXED, "User:foo", "*", AclOperation.CREATE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "mygroup", PatternType.PREFIXED, "User:foo", "*", AclOperation.CREATE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "foo", PatternType.PREFIXED, "User:foo", "*", AclOperation.CREATE, AclPermissionType.ALLOW), new StandardAcl(ResourceType.GROUP, "four_", PatternType.PREFIXED, "User:foo", "127.0.0.100", AclOperation.CREATE, AclPermissionType.DENY));
    public static final List<StandardAcl> ALL = Stream.of(WILDCARD_ACLS, LITERAL_ACLS, PREFIX_ACLS).flatMap(Collection::stream).collect(Collectors.toList());

    public static Uuid idForAcl(StandardAcl acl) {
        return StandardAuthorizerTestConstants.idForConfluentStandardAcl(new ConfluentStandardAcl(acl, Optional.empty()));
    }

    private static Uuid idForConfluentStandardAcl(ConfluentStandardAcl acl) {
        return new Uuid((long)acl.hashCode(), (long)acl.hashCode());
    }

    public static StandardAclWithId withIdAndActiveState(StandardAcl acl) {
        ConfluentStandardAcl confluentStandardAcl = new ConfluentStandardAcl(acl, Optional.empty());
        return new StandardAclWithId(StandardAuthorizerTestConstants.idForConfluentStandardAcl(confluentStandardAcl), confluentStandardAcl);
    }

    public static StandardAclWithId withIdAndDeletedState(StandardAcl acl) {
        ConfluentStandardAcl confluentStandardAcl = new ConfluentStandardAcl(acl, Optional.empty(), AclState.DELETED);
        return new StandardAclWithId(StandardAuthorizerTestConstants.idForConfluentStandardAcl(confluentStandardAcl), confluentStandardAcl);
    }

    public static List<StandardAclWithId> withIds(List<StandardAcl> input) {
        return input.stream().map(StandardAuthorizerTestConstants::withIdAndActiveState).collect(Collectors.toList());
    }

    public static List<StandardAclWithId> withIdsAndDeletedState(List<StandardAcl> input) {
        return input.stream().map(StandardAuthorizerTestConstants::withIdAndDeletedState).collect(Collectors.toList());
    }
}

