/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class StandardAclWithIdTest {
    static final List<Uuid> TEST_UUIDS = Arrays.asList(Uuid.fromString((String)"QZDDv-R7SyaPgetDPGd0Mw"), Uuid.fromString((String)"SdDjEdlbRmy2__WFKe3RMg"));

    @Test
    public void testToRecordRoundTrips() {
        StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.ALL).forEach(acl -> {
            AccessControlEntryRecord record = acl.toRecord();
            StandardAclWithId acl2 = StandardAclWithId.fromRecord((AccessControlEntryRecord)record);
            Assertions.assertEquals((Object)acl2, (Object)acl);
        });
    }

    @Test
    public void testEquals() {
        List<StandardAclWithId> allWithId = StandardAuthorizerTestConstants.withIds(StandardAuthorizerTestConstants.ALL);
        allWithId.forEach(acl1 -> allWithId.forEach(acl2 -> {
            if (acl1 == acl2) {
                Assertions.assertEquals((Object)acl1, (Object)acl2);
            } else {
                Assertions.assertNotEquals((Object)acl1, (Object)acl2);
            }
        }));
    }

    @Test
    public void testNotEqualsIfIdIsDifferent() {
        Assertions.assertNotEquals((Object)new StandardAclWithId(TEST_UUIDS.get(0), new ConfluentStandardAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0), Optional.empty())), (Object)new StandardAclWithId(TEST_UUIDS.get(1), new ConfluentStandardAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0), Optional.empty())));
    }

    @Test
    public void testNotEqualsIfAclIsDifferent() {
        Assertions.assertNotEquals((Object)new StandardAclWithId(TEST_UUIDS.get(0), new ConfluentStandardAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(0), Optional.empty())), (Object)new StandardAclWithId(TEST_UUIDS.get(0), new ConfluentStandardAcl(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1), Optional.empty())));
    }
}

