/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.ResourceAclsBuilder;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTest;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ResourceAclsTest {
    @Test
    public void testEmptyResourceAcls() {
        Assertions.assertTrue((boolean)ResourceAcls.EMPTY.isEmpty());
        Assertions.assertFalse((boolean)ResourceAcls.EMPTY.findMatchingAcl(null, null).isPresent());
    }

    @Test
    public void testResourceAclsChanges() {
        ResourceAclsBuilder changes = new ResourceAclsBuilder();
        Assertions.assertEquals((int)0, (int)changes.numRemovals());
        Assertions.assertEquals((int)0, (int)changes.netSizeChange());
        Assertions.assertFalse((boolean)changes.isRemoved(StandardAuthorizerTestConstants.ALL.get(0)));
        changes.newRemoval(StandardAuthorizerTestConstants.ALL.get(0));
        Assertions.assertTrue((boolean)changes.isRemoved(StandardAuthorizerTestConstants.ALL.get(0)));
        Assertions.assertEquals((int)1, (int)changes.numRemovals());
        Assertions.assertEquals((int)-1, (int)changes.netSizeChange());
        changes.newAddition(StandardAuthorizerTestConstants.ALL.get(1));
        Assertions.assertEquals((int)1, (int)changes.numRemovals());
        Assertions.assertEquals((int)0, (int)changes.netSizeChange());
    }

    @Test
    public void testCopyWithChanges() {
        ResourceAcls twoAcls = new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.ALL.get(0), StandardAuthorizerTestConstants.ALL.get(1)));
        ResourceAclsBuilder changes = new ResourceAclsBuilder();
        changes.newRemoval(StandardAuthorizerTestConstants.ALL.get(0));
        ResourceAcls oneAcl = twoAcls.copyWithChanges(changes);
        Assertions.assertEquals((Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.ALL.get(1))), (Object)oneAcl);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"ResourceAcls(AllowAcls(Entry(StandardAcl(resourceType=TOPIC, resourceName=*, patternType=LITERAL, principal=User:*, host=*, operation=WRITE, permissionType=ALLOW))), DenyAcls(Entry(StandardAcl(resourceType=TOPIC, resourceName=*, patternType=LITERAL, principal=User:bar, host=*, operation=READ, permissionType=DENY))))", (Object)new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.ALL.get(0), StandardAuthorizerTestConstants.ALL.get(1))).toString());
        Assertions.assertEquals((Object)"ResourceAcls(AllowAcls(Entry(StandardAcl(resourceType=TOPIC, resourceName=*, patternType=LITERAL, principal=User:*, host=*, operation=WRITE, permissionType=ALLOW))), DenyAcls())", (Object)new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.ALL.get(0))).toString());
    }

    @Test
    public void testWildcardAuthorize() {
        ResourceAcls resourceAcls = new ResourceAcls(Collections.singletonList(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0)));
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), resourceAcls.findMatchingAcl(AclOperation.WRITE, "127.0.0.1").get());
        Assertions.assertFalse((boolean)resourceAcls.findMatchingAcl(AclOperation.ALTER_CONFIGS, "127.0.0.1").isPresent());
    }

    @Test
    public void testAuthorizeWildcardAclHostMatch() {
        ResourceAcls resourceAcls = new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1)));
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0), resourceAcls.findMatchingAcl(AclOperation.WRITE, "127.0.0.1").get());
        Assertions.assertEquals((Object)StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), resourceAcls.findMatchingAcl(AclOperation.READ, "127.0.0.10").get());
        Assertions.assertFalse((boolean)resourceAcls.findMatchingAcl(AclOperation.READ, "127.0.0.1").isPresent());
    }

    private static AuthorizationResult findResult(Action action, StandardAcl acl) {
        ResourceAcls resourceAcls = new ResourceAcls(Collections.singletonList(acl));
        Optional aclOpt = resourceAcls.findMatchingAcl(action.operation(), "127.0.0.1");
        return aclOpt.map(a -> a.permissionType() == AclPermissionType.ALLOW ? AuthorizationResult.ALLOWED : AuthorizationResult.DENIED).orElse(null);
    }

    @Test
    public void testFindResultImplication() {
        for (AclOperation op : Arrays.asList(AclOperation.DESCRIBE, AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER)) {
            Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(op, AclPermissionType.ALLOW)));
        }
        Assertions.assertNull((Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(AclOperation.CREATE, AclPermissionType.ALLOW)));
        for (AclOperation op : Arrays.asList(AclOperation.READ, AclOperation.WRITE, AclOperation.DELETE, AclOperation.ALTER)) {
            Assertions.assertNull((Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(op, AclPermissionType.DENY)));
        }
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(AclOperation.DESCRIBE, AclPermissionType.DENY)));
        for (AclOperation op : Arrays.asList(AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS)) {
            Assertions.assertEquals((Object)AuthorizationResult.ALLOWED, (Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(op, AclPermissionType.ALLOW)));
        }
        Assertions.assertNull((Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.DESCRIBE_CONFIGS, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.DENY)));
        Assertions.assertEquals((Object)AuthorizationResult.DENIED, (Object)ResourceAclsTest.findResult(StandardAuthorizerTest.newAction(AclOperation.ALTER_CONFIGS, ResourceType.TOPIC, "foo_bar"), StandardAuthorizerTest.newFooAcl(AclOperation.ALTER_CONFIGS, AclPermissionType.DENY)));
    }
}

