/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.metadata.authorizer.PrefixNode;
import org.apache.kafka.metadata.authorizer.PrefixTreeBuilder;
import org.apache.kafka.metadata.authorizer.ResourceAcls;
import org.apache.kafka.metadata.authorizer.ResourceAclsBuilder;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrefixTreeBuilderTest {
    private PrefixTreeBuilder.ChildrenUpdate create(PrefixNode prefixNode, Map.Entry<String, ResourceAclsBuilder> changeEntry) {
        String newResourceName = changeEntry.getKey();
        String floorKey = (String)prefixNode.children().floorKey((Object)newResourceName);
        String ceilingKey = (String)prefixNode.children().ceilingKey((Object)newResourceName);
        return PrefixTreeBuilder.ChildrenUpdate.create((PrefixNode)prefixNode, (String)newResourceName, (String)floorKey, (String)ceilingKey);
    }

    @Test
    public void testChildrenUpdateAddAsChild1() {
        AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder> changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("a", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(PrefixNode.EMPTY, changeEntry));
    }

    @Test
    public void testChildrenUpdateAddAsChild() {
        AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder> changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fm", new ResourceAclsBuilder());
        PrefixNode parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("faa", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("fzz", ResourceAcls.EMPTY, new PrefixNode[0])});
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fb", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fb", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fh", new ResourceAclsBuilder());
        parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("faa", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("fgg", ResourceAcls.EMPTY, new PrefixNode[0])});
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fe", new ResourceAclsBuilder());
        parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("fbb", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0])});
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fa", new ResourceAclsBuilder());
        parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("fbb", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("fgg", ResourceAcls.EMPTY, new PrefixNode[0])});
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.ADD_AS_CHILD, (Object)this.create(parent, changeEntry));
    }

    @Test
    public void testChildrenUpdateChangeAffectsChildOrGrandchild() {
        PrefixNode parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0])});
        AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder> changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("foooo", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CHANGE_AFFECTS_CHILD_OR_GRANDCHILD, (Object)this.create(parent, changeEntry));
        parent = new PrefixNode("f", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("faa", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("fzz", ResourceAcls.EMPTY, new PrefixNode[0])});
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("faaaa", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CHANGE_AFFECTS_CHILD_OR_GRANDCHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("foooo", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CHANGE_AFFECTS_CHILD_OR_GRANDCHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fzzzz", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CHANGE_AFFECTS_CHILD_OR_GRANDCHILD, (Object)this.create(parent, changeEntry));
    }

    @Test
    public void testChildrenUpdateCreateACommonParent() {
        PrefixNode parent = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0])});
        AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder> changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("four", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        parent = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("bbb", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("ooo", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("mmm", ResourceAcls.EMPTY, new PrefixNode[0])});
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("ball", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("bcc", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("oaa", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("orange", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("maa", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("mzz", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.CREATE_A_COMMON_PARENT, (Object)this.create(parent, changeEntry));
    }

    @Test
    public void testChildrenUpdateInsertBeforeAChild() {
        PrefixNode parent = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("foo", ResourceAcls.EMPTY, new PrefixNode[0])});
        AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder> changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("fo", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.INSERT_BEFORE_A_CHILD, (Object)this.create(parent, changeEntry));
        parent = new PrefixNode("ff", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("ffbbb", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("ffooo", ResourceAcls.EMPTY, new PrefixNode[0]), new PrefixNode("ffmmm", ResourceAcls.EMPTY, new PrefixNode[0])});
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("ffbb", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.INSERT_BEFORE_A_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("ffo", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.INSERT_BEFORE_A_CHILD, (Object)this.create(parent, changeEntry));
        changeEntry = new AbstractMap.SimpleImmutableEntry<String, ResourceAclsBuilder>("ffm", new ResourceAclsBuilder());
        Assertions.assertEquals((Object)PrefixTreeBuilder.ChildrenUpdate.INSERT_BEFORE_A_CHILD, (Object)this.create(parent, changeEntry));
    }

    @Test
    public void testRootOnlyBuildNode() {
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0));
        builder.newAddition(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1));
        PrefixNode newNode = builder.build(PrefixNode.EMPTY);
        PrefixNode expected = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[0]);
        Assertions.assertEquals((Object)expected, (Object)newNode);
    }

    @Test
    public void testAddNewChild() {
        PrefixNode root = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[0]);
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0)), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testAddToExistingChild() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3)), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3), StandardAuthorizerTestConstants.PREFIX_ACLS.get(4))), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testInsertNewNodeBeforeChild() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0])})});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testInsertEmptyParentForTwoChildren() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0])})});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5)), new PrefixNode[]{new PrefixNode("fo", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0]), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6)), new PrefixNode[0])})})});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testInsertBeforeAChild() {
        StandardAcl ffbbb = new StandardAcl(ResourceType.GROUP, "ffbbb", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        StandardAcl ffmmm = new StandardAcl(ResourceType.GROUP, "ffmmm", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        StandardAcl ffooo = new StandardAcl(ResourceType.GROUP, "ffooo", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        PrefixNode root = new PrefixNode("ff", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("ffbbb", new ResourceAcls(ffbbb), new PrefixNode[0]), new PrefixNode("ffooo", new ResourceAcls(ffooo), new PrefixNode[0]), new PrefixNode("ffmmm", new ResourceAcls(ffmmm), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        StandardAcl ffbb = new StandardAcl(ResourceType.GROUP, "ffbb", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        builder.newAddition(ffbb);
        PrefixNode newNode = builder.build(root);
        PrefixNode expected = new PrefixNode("ff", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("ffbb", new ResourceAcls(ffbb), new PrefixNode[]{new PrefixNode("ffbbb", new ResourceAcls(ffbbb), new PrefixNode[0])}), new PrefixNode("ffooo", new ResourceAcls(ffooo), new PrefixNode[0]), new PrefixNode("ffmmm", new ResourceAcls(ffmmm), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)newNode);
        builder = new PrefixTreeBuilder();
        StandardAcl ffmm = new StandardAcl(ResourceType.GROUP, "ffmm", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        builder.newAddition(ffmm);
        newNode = builder.build(root);
        expected = new PrefixNode("ff", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("ffbbb", new ResourceAcls(ffbbb), new PrefixNode[0]), new PrefixNode("ffooo", new ResourceAcls(ffooo), new PrefixNode[0]), new PrefixNode("ffmm", new ResourceAcls(ffmm), new PrefixNode[]{new PrefixNode("ffmmm", new ResourceAcls(ffmmm), new PrefixNode[0])})});
        Assertions.assertEquals((Object)expected, (Object)newNode);
        builder = new PrefixTreeBuilder();
        StandardAcl ffoo = new StandardAcl(ResourceType.GROUP, "ffoo", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        builder.newAddition(ffoo);
        newNode = builder.build(root);
        expected = new PrefixNode("ff", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("ffbbb", new ResourceAcls(ffbbb), new PrefixNode[0]), new PrefixNode("ffoo", new ResourceAcls(ffoo), new PrefixNode[]{new PrefixNode("ffooo", new ResourceAcls(ffooo), new PrefixNode[0])}), new PrefixNode("ffmmm", new ResourceAcls(ffmmm), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)newNode);
    }

    @Test
    public void testInsertBeforeAChild2() {
        StandardAcl aa = new StandardAcl(ResourceType.GROUP, "aa", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        StandardAcl akba = new StandardAcl(ResourceType.GROUP, "akba", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        StandardAcl aka = new StandardAcl(ResourceType.GROUP, "aka", PatternType.PREFIXED, "User:*", "*", AclOperation.READ, AclPermissionType.ALLOW);
        PrefixNode root = new PrefixNode("a", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("aa", new ResourceAcls(aa), new PrefixNode[0]), new PrefixNode("akba", new ResourceAcls(akba), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(aka);
        PrefixNode newNode = builder.build(root);
        PrefixNode expected = new PrefixNode("a", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("aa", new ResourceAcls(aa), new PrefixNode[0]), new PrefixNode("ak", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("aka", new ResourceAcls(aka), new PrefixNode[0]), new PrefixNode("akba", new ResourceAcls(akba), new PrefixNode[0])})});
        Assertions.assertEquals((Object)expected, (Object)newNode);
    }

    @Test
    public void testTwoAdditionsToSameBranch() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0])})});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(8));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3), StandardAuthorizerTestConstants.PREFIX_ACLS.get(4), StandardAuthorizerTestConstants.PREFIX_ACLS.get(5))), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2), StandardAuthorizerTestConstants.PREFIX_ACLS.get(8))), new PrefixNode[0])})});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testAddToTwoDifferentBranches() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[0])}), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1)), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(5));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(8));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(7));
        PrefixNode newRoot = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3), StandardAuthorizerTestConstants.PREFIX_ACLS.get(4), StandardAuthorizerTestConstants.PREFIX_ACLS.get(5))), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2), StandardAuthorizerTestConstants.PREFIX_ACLS.get(8))), new PrefixNode[0])}), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1), StandardAuthorizerTestConstants.PREFIX_ACLS.get(7))), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)newRoot);
    }

    @Test
    public void testSimpleRemoveAcl() {
        PrefixNode root = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[0]);
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newRemoval(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0));
        StandardAcl acl = StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1);
        PrefixNode expected = new PrefixNode("", new ResourceAcls(acl), new PrefixNode[0]);
        PrefixNode actual = builder.build(root);
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertTrue((boolean)actual.validateAclCache(acl.kafkaPrincipal(), acl.resourceType(), acl.resourceName()));
    }

    @Test
    public void testSimpleAddAndRemoveAcl() {
        PrefixNode root = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[0]);
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newRemoval(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0));
        builder.newAddition(StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1));
        PrefixNode expected = new PrefixNode("", new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1), StandardAuthorizerTestConstants.WILDCARD_ACLS.get(1))), new PrefixNode[0]);
        Assertions.assertEquals((Object)expected, (Object)builder.build(root));
    }

    @Test
    public void testRemoveAclFromChildAndGrandChild() {
        PrefixNode root = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3).resourceName(), new ResourceAcls(Arrays.asList(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3), StandardAuthorizerTestConstants.PREFIX_ACLS.get(4))), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0)), new PrefixNode[0])})}), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1)), new PrefixNode[0])});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newRemoval(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(0));
        builder.newRemoval(StandardAuthorizerTestConstants.PREFIX_ACLS.get(2));
        builder.newRemoval(StandardAuthorizerTestConstants.PREFIX_ACLS.get(3));
        PrefixNode expected = new PrefixNode("", new ResourceAcls(StandardAuthorizerTestConstants.WILDCARD_ACLS_1.get(1)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(4)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(0)), new PrefixNode[0])}), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(1)), new PrefixNode[0])});
        Assertions.assertEquals((Object)expected, (Object)builder.build(root));
    }

    @Test
    public void testRemoveAndAddWithCommonParent() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9)), new PrefixNode[0])})});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newRemoval(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6));
        builder.newAddition(StandardAuthorizerTestConstants.PREFIX_ACLS.get(8));
        PrefixNode actual = builder.build(root);
        PrefixNode expected = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode("fo", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9)), new PrefixNode[0]), new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(8).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(8)), new PrefixNode[0])})});
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRemoveWholeBranch() {
        PrefixNode root = new PrefixNode("", ResourceAcls.EMPTY, new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6)), new PrefixNode[]{new PrefixNode(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9).resourceName(), new ResourceAcls(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9)), new PrefixNode[0])})});
        PrefixTreeBuilder builder = new PrefixTreeBuilder();
        builder.newRemoval(StandardAuthorizerTestConstants.PREFIX_ACLS.get(6));
        builder.newRemoval(StandardAuthorizerTestConstants.PREFIX_ACLS.get(9));
        PrefixNode actual = builder.build(root);
        PrefixNode expected = PrefixNode.EMPTY;
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

