/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.MockAuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=40L)
public class ClusterMetadataAuthorizerTest {
    static final List<AclBinding> TEST_BINDINGS = Arrays.asList(new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.READ, AclPermissionType.ALLOW)), new AclBinding(new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), new AccessControlEntry("User:*", "*", AclOperation.WRITE, AclPermissionType.ALLOW)));
    static final List<AclBindingFilter> TEST_FILTERS = TEST_BINDINGS.stream().map(AclBinding::toFilter).collect(Collectors.toList());

    @Test
    public void testCreateAcls() throws Exception {
        MockAclMutator mutator = new MockAclMutator();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.setAclMutator(mutator);
        CompletableFuture<List<AclCreateResult>> response = new CompletableFuture<List<AclCreateResult>>();
        response.complete(Arrays.asList(AclCreateResult.SUCCESS, new AclCreateResult((ApiException)new InvalidRequestException("invalid"))));
        mutator.setCreateAclsResponse(response);
        List results = authorizer.createAcls(new MockAuthorizableRequestContext.Builder().build(), TEST_BINDINGS);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals(Optional.empty(), (Object)((AclCreateResult)((CompletionStage)results.get(0)).toCompletableFuture().get()).exception());
        Assertions.assertEquals(InvalidRequestException.class, ((ApiException)((AclCreateResult)((CompletionStage)results.get(1)).toCompletableFuture().get()).exception().get()).getClass());
    }

    @Test
    public void testCreateAclsError() throws Exception {
        MockAclMutator mutator = new MockAclMutator();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.setAclMutator(mutator);
        CompletableFuture<List<AclCreateResult>> response = new CompletableFuture<List<AclCreateResult>>();
        response.completeExceptionally((Throwable)new AuthorizationException("not authorized"));
        mutator.setCreateAclsResponse(response);
        List results = authorizer.createAcls(new MockAuthorizableRequestContext.Builder().build(), TEST_BINDINGS);
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertEquals(AuthorizationException.class, ((ApiException)((AclCreateResult)((CompletionStage)results.get(0)).toCompletableFuture().get()).exception().get()).getClass());
        Assertions.assertEquals(AuthorizationException.class, ((ApiException)((AclCreateResult)((CompletionStage)results.get(1)).toCompletableFuture().get()).exception().get()).getClass());
    }

    @Test
    public void testDeleteAcls() throws Exception {
        MockAclMutator mutator = new MockAclMutator();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.setAclMutator(mutator);
        CompletableFuture<List<AclDeleteResult>> response = new CompletableFuture<List<AclDeleteResult>>();
        response.complete(Arrays.asList(new AclDeleteResult(Collections.singleton(new AclDeleteResult.AclBindingDeleteResult(TEST_BINDINGS.get(0)))), new AclDeleteResult((ApiException)new InvalidRequestException("invalid"))));
        mutator.setDeleteAclsResponse(response);
        List results = authorizer.deleteAcls(new MockAuthorizableRequestContext.Builder().build(), TEST_FILTERS);
        Assertions.assertEquals((int)2, (int)results.size());
        Collection deleteResults0 = ((AclDeleteResult)((CompletionStage)results.get(0)).toCompletableFuture().get()).aclBindingDeleteResults();
        Assertions.assertEquals((int)1, (int)deleteResults0.size());
        AclDeleteResult.AclBindingDeleteResult deleteResult0 = (AclDeleteResult.AclBindingDeleteResult)deleteResults0.iterator().next();
        Assertions.assertEquals((Object)TEST_BINDINGS.get(0), (Object)deleteResult0.aclBinding());
        Assertions.assertEquals(Optional.empty(), (Object)deleteResult0.exception());
        AclDeleteResult deleteResult1 = (AclDeleteResult)((CompletionStage)results.get(1)).toCompletableFuture().get();
        Assertions.assertEquals((int)0, (int)deleteResult1.aclBindingDeleteResults().size());
        Assertions.assertEquals(InvalidRequestException.class, ((ApiException)deleteResult1.exception().get()).getClass());
    }

    @Test
    public void testDeleteAclsError() throws Exception {
        MockAclMutator mutator = new MockAclMutator();
        MockClusterMetadataAuthorizer authorizer = new MockClusterMetadataAuthorizer();
        authorizer.setAclMutator(mutator);
        CompletableFuture<List<AclDeleteResult>> response = new CompletableFuture<List<AclDeleteResult>>();
        response.completeExceptionally((Throwable)new AuthorizationException("not authorized"));
        mutator.setDeleteAclsResponse(response);
        List results = authorizer.deleteAcls(new MockAuthorizableRequestContext.Builder().build(), TEST_FILTERS);
        Assertions.assertEquals((int)2, (int)results.size());
        for (int i = 0; i < 2; ++i) {
            AclDeleteResult deleteResult = (AclDeleteResult)((CompletionStage)results.get(i)).toCompletableFuture().get();
            Assertions.assertEquals((int)0, (int)deleteResult.aclBindingDeleteResults().size());
            Assertions.assertEquals(AuthorizationException.class, ((ApiException)deleteResult.exception().get()).getClass());
        }
    }

    static class MockAclMutator
    implements AclMutator {
        private CompletableFuture<List<AclCreateResult>> createAclsResponse;
        private CompletableFuture<List<AclDeleteResult>> deleteAclsResponse;

        MockAclMutator() {
        }

        void setCreateAclsResponse(CompletableFuture<List<AclCreateResult>> createAclsResponse) {
            this.createAclsResponse = createAclsResponse;
        }

        public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings) {
            return this.createAclsResponse;
        }

        public CompletableFuture<List<AclCreateResult>> createAcls(ControllerRequestContext context, List<AclBinding> aclBindings, AclState aclState) {
            return this.createAclsResponse;
        }

        void setDeleteAclsResponse(CompletableFuture<List<AclDeleteResult>> deleteAclsResponse) {
            this.deleteAclsResponse = deleteAclsResponse;
        }

        public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters) {
            return this.deleteAclsResponse;
        }

        public CompletableFuture<List<AclDeleteResult>> deleteAcls(ControllerRequestContext context, List<AclBindingFilter> aclBindingFilters, AclState aclState) {
            return this.deleteAclsResponse;
        }
    }

    static class MockClusterMetadataAuthorizer
    implements ClusterMetadataAuthorizer {
        volatile AclMutator aclMutator;

        MockClusterMetadataAuthorizer() {
        }

        public void setAclMutator(AclMutator aclMutator) {
            this.aclMutator = aclMutator;
        }

        public AclMutator aclMutatorOrException() {
            if (this.aclMutator == null) {
                throw new NotControllerException("The current node is not the active controller.");
            }
            return this.aclMutator;
        }

        public void completeInitialLoad() {
        }

        public void completeInitialLoad(Exception e) {
        }

        public void loadAclSnapshot(Map<Uuid, ConfluentStandardAcl> acls) {
        }

        public void applyAclChanges(Map<Uuid, Optional<ConfluentStandardAcl>> aclChanges) {
        }

        public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return null;
        }

        public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() throws IOException {
        }

        public void configure(Map<String, ?> configs) {
        }
    }
}

